<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/search/newsearch-templates.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>
    <xsl:output encoding="UTF-8" method="html" indent="no"/>
    <xsl:strip-space elements="*"/>

    <xsl:template match="/RESPONSE[not(URL/dependencyType) and not(URL/category)]">
		<div id="template-" class="form-field form-item" style="display:none;">
			<xsl:call-template name="build-info-line">
				<xsl:with-param name="moduleDenom" select="$search-module-denom"/>
				<xsl:with-param name="defaultFieldDenom" select="$search-config/DEFAULTFIELD"/>
				<xsl:with-param name="defaultOperator" select="$search-config/DEFAULTOPERATOR"/>
				<xsl:with-param name="defaultOperands" select="$search-config/DEFAULTOPERANDS"/>
			</xsl:call-template>
            <a class="remove icon" onclick="return $('#{$panelID}.panel').advancedsearcher('removeCrit', this);" title="Remove this criterion">
                <img src="{$systemImagesURL}icons/search/remove.png"/>
            </a>
            <div class="clear"/>
		</div>
    </xsl:template>
    
    <xsl:template match="/RESPONSE[URL/dependencyType]">
    	<xsl:variable name="dep-in-config" select="$search-config//DEPENDENCY[TYPE=/RESPONSE/URL/dependencyType]" />

        <!-- conversion for JavaScript ID usage -->
        <xsl:variable name="type-str">
            <xsl:call-template name="replace-string">
                <xsl:with-param name="text"><xsl:value-of select="$dep-in-config/TYPE"/></xsl:with-param>
                <xsl:with-param name="from">:</xsl:with-param>
                <xsl:with-param name="to">__</xsl:with-param>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="lineContainerID">
            <xsl:text>template-</xsl:text>
            <xsl:value-of select="$type-str"/>
        </xsl:variable>

        <!-- default info line template for each dependency module -->
        <div id="{$lineContainerID}" class="form-item" style="display:none;">
            <xsl:call-template name="build-dep-info-line">
                <xsl:with-param name="moduleDenom" select="$dep-in-config/MODULE"/>
                <xsl:with-param name="defaultFieldDenom" select="$dep-in-config/DEFAULTFIELD"/>
                <xsl:with-param name="defaultOperator" select="$dep-in-config/DEFAULTOPERATOR"/>
                <xsl:with-param name="defaultOperands" select="$dep-in-config/DEFAULTOPERANDS"/>
                <xsl:with-param name="dependencyType" select="$dep-in-config/TYPE"/>
            </xsl:call-template>
            <a class="remove icon" onclick="return $('#{$panelID}.panel').advancedsearcher('removeCrit', this);" title="Remove this criterion">
                <img src="{$systemImagesURL}icons/search/remove.png"/>
            </a>
            <div class="clear"/>
        </div>

        <!-- conversion for JavaScript ID usage -->
        <xsl:variable name="module-str">
            <xsl:call-template name="replace-string">
                <xsl:with-param name="text"><xsl:value-of select="$dep-in-config/MODULE"/></xsl:with-param>
                <xsl:with-param name="from">:</xsl:with-param>
                <xsl:with-param name="to">__</xsl:with-param>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="groupContainerID">
            <xsl:text>template-dependency-</xsl:text>
            <xsl:value-of select="$type-str"/>
            <xsl:text>-</xsl:text>
            <xsl:value-of select="$module-str"/>
        </xsl:variable>

        <!-- group template for each dependency module... -->
        <div id="{$groupContainerID}" class="form-field form-item dependency-fields-group" style="display:none;">
            <div class="frame">
                <em><xsl:value-of select="$dep-in-config/DESC"/></em>
                <!-- initialized with its default info line template -->
                <div id="form-field-" class="form-item">
                    <xsl:call-template name="build-dep-info-line">
                        <xsl:with-param name="moduleDenom" select="$dep-in-config/MODULE"/>
                        <xsl:with-param name="defaultFieldDenom" select="$dep-in-config/DEFAULTFIELD"/>
                        <xsl:with-param name="defaultOperator" select="$dep-in-config/DEFAULTOPERATOR"/>
                        <xsl:with-param name="defaultOperands" select="$dep-in-config/DEFAULTOPERANDS"/>
                        <xsl:with-param name="dependencyType" select="$dep-in-config/TYPE"/>
                    </xsl:call-template>
                    <a class="add icon" onclick="return $('#{$panelID}.panel').advancedsearcher('addCrit', this, '{$dep-in-config/TYPE}');" title="Add a criterion to this group">
                        <img src="{$systemImagesURL}icons/search/add.png"/>
                    </a>
                    <div class="clear"/>
                </div>
            </div>
            <a class="remove icon" title="Remove this group">
                <xsl:attribute name="onclick">
                    <xsl:for-each select="$dep-in-config/DEPENDENCIES/DEPENDENCY">
                    	$('#<xsl:value-of select="$panelID" />.panel').advancedsearcher('restoreDependencySearchOption', '<xsl:value-of select="./TYPE"/>', '<xsl:value-of select="./MODULE"/>');
                    </xsl:for-each>
                    $('#<xsl:value-of select="$panelID" />.panel').advancedsearcher('removeDependencySearch', this, '<xsl:value-of select="$dep-in-config/TYPE"/>', '<xsl:value-of select="$dep-in-config/MODULE"/>');
                    return false;
                </xsl:attribute>
                <img src="{$systemImagesURL}icons/search/remove.png"/>
            </a>
        </div>
    </xsl:template>
    
    <xsl:template match="/RESPONSE[URL/category]">
    	<xsl:variable name="currentCateg" select="/RESPONSE/RESULTS//CATEGORY[UNIQUENAME=/RESPONSE/URL/category]" />

		<div id="template-category-{$currentCateg/UNIQUENAME}" class="form-item" style="display:none;"> 
			<xsl:call-template name="build-single-categ-line">
                  <xsl:with-param name="targetCategName" select="$currentCateg/UNIQUENAME"/>
                  <xsl:with-param name="defaultOperator" select="'IS'"/>
                  <xsl:with-param name="defaultCateg" select="''"/>
                  <xsl:with-param name="lineID" select="''"/>
                  <xsl:with-param name="addButton" select="0"/>
                     <xsl:with-param name="containerID">
                         <xsl:text>template-category-</xsl:text>
                         <xsl:value-of select="$currentCateg/UNIQUENAME" />
                     </xsl:with-param>
			</xsl:call-template>
		</div>
		<div id="template-category-group-{$currentCateg/UNIQUENAME}" class="form-field form-item category-fields-group" style="display:none;">
               <div class="frame">
                   <em>Corresponds to one of the following "<xsl:value-of select="$currentCateg/LABEL" />" categories...</em>
				<div id="form-field-" class="form-item">
                       <xsl:call-template name="build-single-categ-line">
	                       <xsl:with-param name="targetCategName" select="$currentCateg/UNIQUENAME"/>
                           <xsl:with-param name="defaultOperator" select="'descendant'"/>
                           <xsl:with-param name="defaultCateg" select="''"/>
                           <xsl:with-param name="lineID" select="''"/>
                           <xsl:with-param name="addButton" select="1"/>
                              <xsl:with-param name="containerID">
                                  <xsl:text>template-category-group-</xsl:text>
		                         <xsl:value-of select="$currentCateg/UNIQUENAME" />
                              </xsl:with-param>
                       </xsl:call-template>
				</div>
               </div>
               <!--a class="add-categ icon" title="Add a group of categories">
                   <img src="{$systemImagesURL}icons/search/add.png"/>
               </a-->
               <a class="remove icon" onclick="return $('#{$panelID}.panel').advancedsearcher('removeCrit', this);" title="Remove this group of categories">
                   <img src="{$systemImagesURL}icons/search/remove.png"/>
               </a>
		</div>
    </xsl:template>
</xsl:stylesheet>
