<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/security/OwnersPermissions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
	<!-- parameters -->
    <xsl:param name="module" select="/RESPONSE/URL/module"/>
    <xsl:param name="searchText" select="/RESPONSE/URL/quicksearch-text" />
    <xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*" />

	<xsl:template match="/RESPONSE">
		<xsl:call-template name="panel-quicksearch">
			<xsl:with-param name="list" select="/RESPONSE/RESULTS[@name='list']"/>
	        <xsl:with-param name="addNew" select="true()"/>
	        <xsl:with-param name="pagingStyle" select="'none'"/>
	        <xsl:with-param name="params">
				<xsl:text>elementID:</xsl:text>
				<xsl:value-of select="/RESPONSE/URL/elementID" />
	        </xsl:with-param>
	        <xsl:with-param name="searchText" select="'Search for users...'" />
		</xsl:call-template>
    </xsl:template>

	<!-- custom : quicksearch list header -->
	<xsl:template name="panel-list-header-quicksearch">
        <xsl:param name="list" />
        <xsl:param name="module" />
        <xsl:param name="addNew" />
        <xsl:param name="addNewScript" />
	</xsl:template>
	
	<!-- custom : quicksearch list -->
	<xsl:template name="panel-list-quicksearch">
		<xsl:param name="list" />

		<xsl:choose>
			<xsl:when test="$list/@hits > 0">
		        <xsl:call-template name="staticitem-selectall">
		        	<xsl:with-param name="id">
		        		<xsl:text>selectall-</xsl:text>
		        		<xsl:value-of select="$panelID" />
		        	</xsl:with-param>
		        	<xsl:with-param name="title" select="'Select all'" />
		        	<xsl:with-param name="displayRemoveOption" select="false()" />
		        	<xsl:with-param name="applyToWho" select="'owners'" />
		        	<xsl:with-param name="element" select="$item" />
		        </xsl:call-template>
        
				<xsl:for-each select="$list/*">
					<xsl:sort select="translate(concat(INFO[CONTACTTYPE='PP']/LASTNAME,INFO[CONTACTTYPE='PP']/FIRSTNAME,INFO[CONTACTTYPE='PM']/DENOMINATION), $xsltsl-str-upper, $xsltsl-str-lower)" order="ascending"/>	
					<xsl:apply-templates select="." mode="element-navitem-quicksearch" />
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="not(/RESPONSE/URL/quicksearch-text/text()) and $item/INFO/OWNERS/CONTACT">
				        <xsl:call-template name="staticitem-selectall">
				        	<xsl:with-param name="id">
				        		<xsl:text>selectall-</xsl:text>
				        		<xsl:value-of select="$panelID" />
				        	</xsl:with-param>
				        	<xsl:with-param name="title" select="'Select all'" />
				        	<xsl:with-param name="displayRemoveOption" select="true()" />
				        	<xsl:with-param name="applyToWho" select="'owners'" />
				        	<xsl:with-param name="element" select="$item" />
				        </xsl:call-template>
        
						<xsl:for-each select="$item/INFO/OWNERS/CONTACT">
							<xsl:sort select="@lastname" />
							<xsl:sort select="@denomination" />
							<xsl:apply-templates select="." mode="element-item-existing" />
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<div class="no-result">No users found</div>
					</xsl:otherwise>
	                
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
		
        <xsl:if test="/RESPONSE/URL/quicksearch-text/text()">
	        <xsl:call-template name="nav-new">
	            <xsl:with-param name="title">Create a new contact...</xsl:with-param>
	            <xsl:with-param name="module" select="'CONTACT'" />
	            <xsl:with-param name="panelURI" select="'../../system/tools/element/New'" />
	            <xsl:with-param name="params">
		            <xsl:text>searchText:'</xsl:text>
		            <xsl:value-of select="/RESPONSE/URL/quicksearch-text" />
		            <xsl:text>'</xsl:text>
	            </xsl:with-param>
	            <xsl:with-param name="cssclass" select="'grey-bkgnd'" />
	        </xsl:call-template>
        </xsl:if>
	</xsl:template>
	
	<!-- search results : new contacts -->
    <xsl:template match="CONTACT[not(@ID = /RESPONSE/RESULTS[@name='item']/*/INFO/OWNERS/CONTACT/@ID)]" mode="element-navitem-quicksearch">
        <xsl:apply-templates select="." mode="element-navitem-check-action">
        	<xsl:with-param name="actions-block">
                <select id="select-security-contact-{@ID}" style="width:95%;">
                	<xsl:attribute name="onchange">
                		$('#<xsl:value-of select="$panelID"/>.panel').trigger('apply-single-permission', [this, 'owners', '<xsl:value-of select="$module" />', <xsl:value-of select="$item/@ID" />]);
                	</xsl:attribute>
                    <option value="">Permissions...</option>
                    <xsl:for-each select="/RESPONSE/RESULTS/LIST[@name='PermissionsAssignations']/*[@value!='remove']">
                        <xsl:sort select="@label" />
                        <option value="{@value}">
		                    <xsl:value-of select="@label"/>
                        </option>
                    </xsl:for-each>
                </select>
        	</xsl:with-param>
        </xsl:apply-templates>
    </xsl:template>
    
    <!-- search results : existing contacts -->
    <xsl:template match="CONTACT" mode="element-navitem-quicksearch">
        <xsl:apply-templates select="." mode="element-navitem" />
    </xsl:template>
    
    <!-- existing contacts on the item -->
    <xsl:template match="CONTACT" mode="element-item-existing">
        <xsl:apply-templates select="." mode="element-navitem-check-action">
        	<xsl:with-param name="actions-block">
                <select id="select-security-contact-{@ID}" style="width:95%;">
                	<xsl:attribute name="onchange">
                		$('#<xsl:value-of select="$panelID"/>.panel').trigger('apply-single-permission', [this, 'owners', '<xsl:value-of select="$module" />', <xsl:value-of select="$item/@ID" />]);
                	</xsl:attribute>
                	<xsl:variable name="contact" select="." />
                    <xsl:for-each select="/RESPONSE/RESULTS/LIST[@name='PermissionsTypes']/*">
                        <xsl:sort select="@label" />
                        <option value="{@value}">
                        	<xsl:if test="@value=$contact/@security">
                        		<xsl:attribute name="selected">selected</xsl:attribute>
                        	</xsl:if>
		                    <xsl:value-of select="@label"/>
                        </option>
                    </xsl:for-each>
                </select>
        	</xsl:with-param>
        </xsl:apply-templates>
    </xsl:template>

	<xsl:template name="panel-add-js">
		<!--  see import.xsl -->
		<xsl:call-template name="security-actions-js" />	
	</xsl:template>
</xsl:stylesheet>
