<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/Library/updates/20101025-logs/portLastMonth.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
include_once('../../../common/common_functions.inc.php');
include_once('portLogs.class.php');
include_once('../../../common/nql.class.php');
include_once('../../../common/sushee.class.php');

set_time_limit(0);
session_write_close();

class Sushee_LastMonthLogPorter{
	
	function execute(){
		$files_to_port = new Sushee_Logports_iterator(true); // boolean passed it to indicate its the last month we want
		
		// a porter that inserts the log but in the right place, because log files are now used (new lines could be inserted) and should be coherent
		$logfile_porter = new Sushee_LogFilePorter(new Sushee_LogSortedInserter());
		// disabling compression because the files here have to be locked (because new system is already running) and locking is impossible on compressed files
		$logfile_porter->enableCompression(false);
		//$logfile_porter = new Sushee_LogFilePorter(new Sushee_LogBasicInserter());
		// inserting in database the list of files to port (this list wont change as we are handling past logfiles)
		$files_to_port->initialize();
		$to_port = false;
		while($to_port = $files_to_port->next()){
			// porting the file found in database
			echo('porting file '.$to_port->getPath()."\r\n");
			$logfile_porter->execute($to_port);
			if(getTimer() > PORT_TIME_LIMIT )
				break;
		}
		// if no more files, deleting the cron and installing the new SEARCH LOG
		if(!$to_port){
			// 1. deleting the cron
			$shell = new Sushee_shell();
			$sushee = new Sushee_Instance();
			$shell->addCommand(
				'<DELETE>
					<CRON>
						<WHERE>
							<INFO>
								<COMMAND operator="contains">Kernel/Library/updates/20101025-logs/portLastMonth.php</COMMAND>
							</INFO>
						</WHERE>
					</CRON>
				</DELETE>');
			$shell->execute();
			// 2. replacing Kernel/private/searchLog.inc.php
			@copy(dirname(__FILE__).'/searchLog.inc.php','../../../private/searchLog.inc.php');
		}
	}
}

$porter = new Sushee_LastMonthLogPorter();
$porter->execute();

?>