<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/Library/updates/20101025-logs/portLogs.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
include_once('../../../common/common_functions.inc.php');
include_once('portLogs.class.php');
include_once('../../../common/nql.class.php');
include_once('../../../common/sushee.class.php');

set_time_limit(0);
session_write_close();

class Sushee_PastLogPorter{
	
	function execute(){
		$files_to_port = new Sushee_Logports_iterator();
		// a porter that simply inserts the log at the end of the logfile (because log file wont be used, as we are porting past files)
		$logfile_porter = new Sushee_LogFilePorter(new Sushee_LogBasicInserter());
		$logfile_porter->enableCompression(false);
		// inserting in database the list of files to port (this list wont change as we are handling past logfiles)
		$files_to_port->initialize();
		$to_port = false;
		while($to_port = $files_to_port->next()){
			// porting the file found in database
			echo('porting file '.$to_port->getPath()."\r\n");
			$logfile_porter->execute($to_port);
			if(getTimer() > PORT_TIME_LIMIT )
				break;
		}
		// if no more files to port
		if(!$to_port){
		// 1. deleting the cron
			$shell = new Sushee_shell();
			$sushee = new Sushee_Instance();
			$shell->addCommand(
				'<DELETE>
					<CRON>
						<WHERE>
							<INFO>
								<COMMAND operator="contains">Kernel/Library/updates/20101025-logs/portLogs.php</COMMAND>
							</INFO>
						</WHERE>
					</CRON>
				</DELETE>');
		// 2. installing a batch, launched on the first day at midnight of the next month, that will create a cron porting the logs of the last month not yet done, this batch will also install the new system of 3 logs
			$date = new Date();
			$date->setDay(1);
			$date->addMonth(1);
			$shell->addCommand(
				'<CREATE>
					<BATCH>
						<INFO>
							<WISHEDSTART>'.$date->getDate().' 00:00:00</WISHEDSTART>
							<STATUS>pending</STATUS>
							<DOMAIN>sushee</DOMAIN>
							<DENOMINATION>launchPortLastMonth</DENOMINATION>
							<TYPE>url</TYPE>
							<COMMAND>'.$sushee->getURL().'/Kernel/Library/updates/20101025-logs/launchNewSystem.php</COMMAND>
						</INFO>
					</BATCH>
				</CREATE>');
			$shell->execute();
		}
	}
}

$porter = new Sushee_PastLogPorter();
$porter->execute();

?>