<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/Library/xsl/number.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:doc="http://xsltsl.org/xsl/documentation/1.0" xmlns:str="http://xsltsl.org/string">
	
	<xsl:template name="currency">
		<xsl:param name="amount" />
		<xsl:value-of select="$amount"/>
		<xsl:choose>
			<xsl:when test="not(contains($amount,'.'))">
				<xsl:text>.00</xsl:text>
			</xsl:when>
			<xsl:when test="string-length(substring-after($amount,'.')) = 1">
				<xsl:text>0</xsl:text>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<!-- ROUND (call) -->
	
	<xsl:template name="round">
		<xsl:param name="valeur" select="'0'" />
		<xsl:choose>
		<xsl:when test="ceiling($valeur*100) - $valeur*100 &lt;= 0.5">
			<xsl:value-of select="ceiling($valeur*100) div 100"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="floor($valeur*100) div 100"/>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- ROUND (apply) -->
	
	<xsl:template match="*/text()" mode="round">
		<xsl:choose>
			<xsl:when test="ceiling(.*100) - .*100 &lt;= 0.5">
				<xsl:value-of select="ceiling(.*100) div 100"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="floor(.*100) div 100"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>

