<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/common/application.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/nectil_object.class.php");
require_once(dirname(__FILE__)."/../common/nectil_user.class.php");
require_once(dirname(__FILE__)."/../common/namespace.class.php");

class ApplicationCollection extends SusheeObject{
	
	var $list=false;
	
	function getOfficialApplicationRs(){
		$request = new Sushee_Request();
		$db_conn = $request->getApplicationDbConn();
		$sql = 'SELECT * FROM `applications` WHERE `ID` > 2 AND `ID` < 1024 AND `Dockable` = 1 ORDER BY `Denomination`';
		$this->logSQL($sql);
		$app_rs = $db_conn->Execute($sql);
		return $app_rs;
	}
	
	function _initList(){
		$this->list = array();
		$app_rs = $this->getOfficialApplicationRs();
		$user = new NectilUser();
		if($app_rs){
			while($row = $app_rs->FetchRow() ){
				$app = new OfficialApplication($row['Denomination']);
				$app->setRow($row);
				if($app->isActive() && $user->hasApplication($app))
					$this->list[]=$app;
			}
		}
		$custom_app_rs = $this->getCustomApplicationRs();
		if($custom_app_rs){
			while($row = $custom_app_rs->FetchRow() ){
				$app = new CustomApplication($row['Denomination']);
				$app->setRow($row);
				if($app->isActive() && $user->hasApplication($app))
					$this->list[]=$app;
			}
		}
	}
	
	function next(){
		if($this->list===false){
			$this->_initList();
		}
		$app = next($this->list);
		return $app;
	}
	
	function getCustomApplicationRs(){
		$request = new Sushee_Request();
		$db_conn = $request->getApplicationDbConn();
		$custom_app_rs = $db_conn->Execute('SELECT * FROM `applications_custom` ORDER BY `Denomination`');
		if(!$custom_app_rs || $custom_app_rs->RecordCount()==0){
			$sql = 'SELECT * FROM `applications` WHERE `ID` >= 1024 ORDER BY `Denomination`';
			$this->logSQL($sql);
			$custom_app_rs = $db_conn->Execute($sql);
		}
		return $custom_app_rs;
	}
	
	function getLoginXML($languageID){
		
		$user = new NectilUser();
		
		$strResponse='<APPLICATIONS>';
		
		
		$app_rs = $this->getOfficialApplicationRs();
		
		if($app_rs){
			while($row = $app_rs->FetchRow() ){
				$app = new OfficialApplication($row['Denomination']);
				$app->setRow($row);
				if($app->isActive() && $user->hasApplication($app))
					$strResponse.=$app->getLoginXML($languageID);
			}
		}
		
		$custom_app_rs = $this->getCustomApplicationRs();
		if($custom_app_rs){
			while($row = $custom_app_rs->FetchRow() ){
				$app = new CustomApplication($row['Denomination']);
				$app->setRow($row);
				if($app->isActive() && $user->hasApplication($app))
					$strResponse.=$app->getLoginXML($languageID);
			}
		}
		
		$strResponse.='</APPLICATIONS>';
		return $strResponse;
	}
	
	function getSharedXML($languageID){
		$db_conn = db_connect(TRUE);
		$xml = '';
		$xml.='<APPLICATIONS languageID="'.$languageID.'">';
		
		$app_rs = $this->getOfficialApplicationRs();
		if($app_rs){
			while($row = $app_rs->FetchRow() ){
				$app = new OfficialApplication($row['ID']);
				$app->setRow($row);
				if ($app->isActive()){
					$xml.=$app->getSharedXML($languageID);
				}else{
					$this->log('ApplicationCollection.getSharedXML : disabled '.$row['Denomination']);
				}
			}
		}
		
		$app_rs = $this->getCustomApplicationRs();
		if($app_rs){
			while($row = $app_rs->FetchRow() ){
				$app = new CustomApplication($row['ID']);
				$app->setRow($row);
				if ($app->isActive()){
					$xml.=$app->getSharedXML($languageID);
				}else{
					$this->log('ApplicationCollection.getSharedXML : disabled '.$row['Denomination']);
				}
			}
		}
		
		
		$xml.='</APPLICATIONS>';
		return $xml;
	}
	
	function getTraductionXML($languageID){
		
	}
}

class OfficialApplication extends SusheeObject{
	var $ID = false;
	var $name = false;
	var $row = false;
	
	function getID(){
		if($this->ID){
			return $this->ID;
		}else{
			$row = $this->getRow();
			return $row['ID'];
		}
	}
	
	function getSQLCondition(){
		if($this->ID){
			return ' WHERE `ID`=\''.$this->ID.'\'';
		}else{
			return ' WHERE `Denomination`=\''.$this->name.'\'';
		}
	}
	
	function setRow($row){
		$this->row = $row;
	}
	
	function exists(){
		return $this->getRow();
	}
	
	function getRow(){
		if(!$this->row){
			$request = new Sushee_Request();
			$db_conn = $request->getApplicationDbConn();
			$sql = 'SELECT * FROM `applications` '.$this->getSQLCondition();
			$this->row = $db_conn->GetRow($sql);
		}
		return $this->row;
	}
	
	function isActive(){
		$row = $this->getRow();
		if($this->getID()==15){
			$sql = 'SELECT `ID` FROM `residents` WHERE `ID`=1';
			$db_conn = db_connect();
			$template = $db_conn->getRow($sql);
			if(!$template)
				return false;
		}
		if($this->getID()==10){
			$sql = 'SELECT `ID` FROM `mailings` WHERE `ID`=1';
			$db_conn = db_connect();
			$template = $db_conn->getRow($sql);
			if(!$template)
				return false;
		}
		if($this->getID()==11 || $this->getID()==12){
			$sql = 'SELECT `ID` FROM `sound_arts` WHERE `ID`=1';
			$db_conn = db_connect();
			$template = $db_conn->getRow($sql);
			if(!$template)
				return false;
		}
		if($this->getID()==14){
			$sql = 'SELECT `ID` FROM `documents` WHERE `ID`=1';
			$db_conn = db_connect();
			$template = $db_conn->getRow($sql);
			if(!$template)
				return false;
		}
		if($this->getID()==13 || $this->getID()==17){
			if($GLOBALS["nectil_url"]!='officity.com')
				return false;
		}
		
		if(!isNectilMaster($GLOBALS["nectil_url"]) && $GLOBALS["generic_backoffice"] && !isset($GLOBALS['resident_applications'][$row['Denomination']]))
			return false;
		else
			return true;
	}
	
	function OfficialApplication($ID_or_name){
		if(is_numeric($ID_or_name)){
			$this->ID = $ID_or_name;
		}else{
			$this->name = $ID_or_name;
		}
		
	}
	
	function getLoginXML($languageID){
		$row = $this->getRow();
		$user = new NectilUser();
		$key = $user->getApplicationKey($this);
		if($key){
			$security = $key->getField('Permissions');
		}
		
		return '<APPLICATION ID="'.$row["ID"].'" type="'.$row["Type"].'" dockable="'.$row["Dockable"].'" icon="'.$row["Icon"].'" url="'.$row["URL"].'"><APPNAME>'.$row["Denomination"].'</APPNAME><SECURITY>'.$security.'</SECURITY></APPLICATION>';
	}
	
	function getSharedXML($languageID){
		$db_conn = db_connect(TRUE);
		$row = $this->getRow();
		$sql = "SELECT trad.`Denomination`,trad.`SharedText` FROM `traductions` as trad WHERE trad.`LanguageID`=\"$languageID\" AND trad.`ApplicationID`=".$row['ID'].";";
		$trad_row = $db_conn->GetRow($sql);
		if ( !$trad_row ){
			$appTrad=$row["Denomination"];
		}else{
			$appTrad=$trad_row["Denomination"];
			$sharedText = $trad_row["SharedText"];
		}
		$xml = '';
		if($row['Dockable']==0){
			$dockable = 'false';
		}else{
			$dockable = 'true';
		}
		$xml.='<APPLICATION Dockable="'.$dockable.'">';
		$xml.=		'<APPNAME>'.$row["Denomination"].'</APPNAME>';
		$xml.=		'<NAME>'.$appTrad.'</NAME>';
		$xml.=		'<VISUAL>'.$row["IconType"].'</VISUAL>';
		$xml.=		'<SHAREDTEXT>'.$sharedText.'</SHAREDTEXT>';
		$xml.=		'<TYPE>'.$row["Type"].'</TYPE>';
		$xml.='</APPLICATION>';
		return $xml;
	}
	
	function getTraductionXML($languageID){
		$db_conn = db_connect(TRUE);
		$app_row = $this->getRow();
		$xml = '';
		$sql='SELECT `Text` FROM `traductions` WHERE `ApplicationID`=\''.$app_row['ID'].'\' AND `LanguageID`="'.$languageID.'"';
		$this->logSQL($sql);
		$row = $db_conn->GetRow($sql);
		if (!$row){
			$languageID='eng';
			$sql='SELECT `Text` FROM `traductions` WHERE `ApplicationID`=\''.$app_row['ID'].'\' AND `LanguageID`="'.$languageID.'"';
			$row = $db_conn->GetRow($sql);
		}
		
		$xml.='<TRADUCTION languageID="'.$languageID.'">';
		$xml.=		'<TEXT>'.$row["Text"].'</TEXT>';
		$xml.='</TRADUCTION>';
		return $xml;
	}
	
	function getXML(){
		$row = $this->getRow();
		if($row['Dockable']==0){
			$dockable = 'false';
		}else{
			$dockable = 'true';
		}
		$xml.='<APPLICATION ID="'.$row['ID'].'" Dockable="'.$dockable.'">';
		$xml.=		'<APPNAME>'.$row["Denomination"].'</APPNAME>';
		$xml.=		'<TEMPLATE>'.$row["SecurityTemplate"].'</TEMPLATE>';
		$xml.=		'<VISUAL>'.$row["IconType"].'</VISUAL>';
		$xml.=		'<TYPE>'.$row["Type"].'</TYPE>';
		$xml.='</APPLICATION>';
		return $xml;
	}
}


class CustomApplication extends SusheeObject{
	var $ID = false;
	var $name = false;
	var $row = false;
	
	function CustomApplication($ID_or_name){
		if(is_numeric($ID_or_name)){
			$this->ID = $ID_or_name;
		}else{
			$this->name = $ID_or_name;
		}
		
	}
	
	function getID(){
		if($this->ID){
			return $this->ID;
		}else{
			$row = $this->getRow();
			return $row['ID'];
		}
	}
	
	function getName(){
		if($this->name){
			return $this->name;
		}else{
			$row = $this->getRow();
			$this->name = $row['Denomination'];
			return $this->name;
		}
	}
	
	function getNamespace(){
		$name = $this->getName();
		$explosion = explode(':',$name);
		if(sizeof($explosion)>1){
			return new SusheeNamespace($explosion[0]);
		}else
			return false;
	}
	
	
	function setRow($row){
		$this->row = $row;
	}
	
	function getSQLCondition(){
		if($this->ID){
			return ' WHERE `ID`=\''.$this->ID.'\'';
		}else{
			return ' WHERE `Denomination`=\''.$this->name.'\'';
		}
	}
	
	function exists(){
		return is_array($this->getRow());
	}
	
	function isNative(){
		return ($this->getID() < 1024);
	}
	
	function getRow(){
		if(!$this->row){
			$db_conn = db_connect();
			$sql = 'SELECT * FROM `applications_custom` '.$this->getSQLCondition();
			$this->row = $db_conn->GetRow($sql);
			if(!$this->row){
				$sql = 'SELECT * FROM `applications` '.$this->getSQLCondition();
				$this->row = $db_conn->GetRow($sql);
			}
		}
		return $this->row;
	}
	
	function isActive(){
		return true;
	}
	
	function getLoginXML($languageID){
		$row = $this->getRow();
		
		return '<APPLICATION_CUSTOM ID="'.$row["ID"].'" type="'.$row["Type"].'" dockable="'.$row["Dockable"].'" icon="'.$row["Icon"].'" url="'.$row["URL"].'"><APPNAME>'.$row["Denomination"].'</APPNAME><SECURITY></SECURITY><VISUAL>'.$row["Icon"].'</VISUAL><URL>'.$row["URL"].'</URL><TYPE>'.$row["Type"].'</TYPE><CLASS>'.$row["Class"].'</CLASS></APPLICATION_CUSTOM>';
	}
	
	function getSharedXML($languageID){
		$db_conn = db_connect();
		$row = $this->getRow();
		$sql = "SELECT trad.`Denomination` FROM `traductions_custom` as trad WHERE trad.`LanguageID`=\"$languageID\" AND trad.`ApplicationID`=".$row['ID'].";";
		$trad_row = $db_conn->GetRow($sql);
		if ( !$trad_row ){
			$appTrad=$row["Denomination"];
		}else{
			$appTrad=$trad_row["Denomination"];
		}
		$xml = '';
		$xml.='<APPLICATION_CUSTOM Dockable="true">';
		$xml.=		'<APPNAME>'.$row["Denomination"].'</APPNAME>';
		$xml.=		'<NAME>'.$appTrad.'</NAME>';
		$xml.=		'<VISUAL>'.$row["Icon"].'</VISUAL>';
		$xml.=		'<URL>'.$row["URL"].'</URL>';
		$xml.=		'<TYPE>'.$row["Type"].'</TYPE>';
		$xml.=		'<CLASS>'.$row["Type"].'</CLASS>';
		$xml.='</APPLICATION_CUSTOM>';
		return $xml;
	}
	
	function getTraductionXML($languageID){
		$db_conn = db_connect();
		$app_row = $this->getRow();
		$xml = '';
		$sql='SELECT `Text` FROM `traductions_custom` WHERE `ApplicationID`='.$app_row['ID'].' AND `LanguageID`="'.$languageID.'"';
		$row = $db_conn->GetRow($sql);
		if (!$row){
			$languageID='eng';
			$sql='SELECT `Text` FROM `traductions_custom` WHERE `ApplicationID`='.$app_row['ID'].' AND `LanguageID`="'.$languageID.'"';
			$row = $db_conn->GetRow($sql);
		}
		
		$xml.='<TRADUCTION languageID="'.$languageID.'">';
		$xml.=		'<TEXT>'.$row["Text"].'</TEXT>';
		$xml.='</TRADUCTION>';
		return $xml;
	}
	
	function getXML(){
		$row = $this->getRow();
		$xml.='<APPLICATION_CUSTOM ID="'.$row['ID'].'" Dockable="true">';
		$xml.=		'<APPNAME>'.$row["Denomination"].'</APPNAME>';
		$xml.=		'<TEMPLATE>'.$row["SecurityTemplate"].'</TEMPLATE>';
		$xml.=		'<VISUAL>'.$row["Icon"].'</VISUAL>';
		$xml.=		'<URL>'.$row["URL"].'</URL>';
		$xml.=		'<TYPE>'.$row["Type"].'</TYPE>';
		$xml.='</APPLICATION_CUSTOM>';
		return $xml;
	}
}
?>