<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/common/classcaller.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/nectil_object.class.php");


class sushee_PHPClassCaller extends SusheeObject{
	
	var $response = false;
	var $path = false;
	var $className = false;
	var $method = false;
	var $data = false;
	
	function sushee_PHPClassCaller($path,$className,$method,$data){
		$this->path = $path;
		$this->className = $className;
		$this->method = $method;
		$this->data = $data;
	}
	
	function getClassName(){
		return $this->className;
	}
	
	function getPath(){
		return $this->path;
	}
	
	function getMethod(){
		return $this->method;
	}
	
	function execute(){
		$phpfile = new KernelFile($this->getPath());
		if($phpfile->exists()){
			
			// Is it a class with a method to call or a simple PHP script to execute ?
			$classname = $this->getClassName();
			if($classname){
				// checking the classname is not a native sushee class
				$already_included = false;
				// we must first check that the file has not yet been included, otherwise class_exists will return true, but because the file was already included
				$included_files = get_included_files();
				foreach ($included_files as $filename) {
				    if($filename==$phpfile->getCompletePath()){
						$already_included = true;
					}
				}
				if(!$already_included && class_exists($classname)){
					$this->setError('Classname `'.$classname.'` is already used : please use another classname');
					return false;
				}else{
					// a class with a method to call
					include_once($phpfile->getCompletePath());
					if(!class_exists($classname)){
						$this->setError('Class `'.$classname.'` is not defined in the file `'.$phpfile->getCompletePath().'`');
						return false;
					}else{

						$new_object = new $classname($this->data);
						$method = $this->getMethod();
						if(!$method){
							$this->setError('Method is not defined for processor `'.$phpfile->getCompletePath().'`');
							return false;
						}else{

							if(!method_exists($new_object,$method)){
								$this->setError('Method `'.$method.'` does not exist in the class `'.$classname.'`');
							}else{
								$this->response =  $new_object->$method($this->data);
								return true;
							}
						}
					}
				}
			}else{
				$this->setError('ClassName is empty');
				return false;
			}
		}else{
			$this->setError('PHP file `'.$phpfile->getCompletePath().'` does not exist');
		}
		return false;
	}
	
	function getResponse(){
		return $this->response;
	}
	
	
}

?>