<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/common/csv.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/file.class.php');

class Sushee_CSVOutput extends SusheeObject{
	
	var $columnIndexes = array();
	var $allColumns = true;
	var $paging = false;
	var $page = 1;
	var $first_line = false;
	var $last_line = false;
	
	function enableColumn($i){
		if(!$this->returnColumn($i)){
			$this->columnIndexes[] = $i;
		}
	}
	
	function returnColumn($i){
		return $this->allColumns || in_array($i,$this->columnIndexes);
	}
	
	function enableAllColumns($boolean = true){
		$this->allColumns = $boolean;
	}
	
	function _computeLimitsLine(){
		if($this->getPage() && $this->getPaging()){
			$this->last_line = $this->getPage() * $this->getPaging(); 
			$this->first_line = $this->last_line - $this->getPaging();
		}
	}
	
	function enablePaging($paging = 10){
		$this->paging = $paging;
		$this->_computeLimitsLine();
	}
	
	function returnPage($page){
		$this->page = $page;
		$this->_computeLimitsLine();
	}
	
	function getPaging(){
		return $this->paging;
	}
	
	function getPage(){
		return $this->page;
	}
	
	function returnLine($i){
		if(!$this->getPaging()){
			return true;
		}
		
		if($i <= $this->last_line && $i>$this->first_line){
			return true;
		}
		return false;
	}
	
	// if the lines included in the page are now finished
	function isPageFinished($i){
		// no pagination, we include every line
		if(!$this->getPaging())
			return false;
		// line is past last line
		if($i > $this->last_line){
			return true;
		}
		return false;
	}
	
}

class Sushee_CSV extends File{
	
	var $separator = ';';
	var $enclosure = '"';
	var $rowscount = false;
	var $columnscount = false;
	var $fp = false;
	var $hasHeader = true;
	
	function Sushee_CSV($path){
		File::File($path);
		ini_set('auto_detect_line_endings','1');
		$this->_getSeparator();
	}
	
	function _getSeparator(){
		$fp = $this->open();
		$buffer = fgets($fp);
		$this->close();
		$explode_virgule = explode(',',$buffer);
		$explode_pointvirgule = explode(';',$buffer);
		if(sizeof($explode_virgule)>1)
			$separator = ',';
		else if(sizeof($explode_pointvirgule)>1)
			$separator = ';';
		else
			$separator = ','; // one column case
		$this->separator = $separator;
	}
	
	function setSeparator($separator){
		$this->separator = $separator;
	}
	
	function hasHeader($boolean=true){
		$this->hasHeader = $boolean;
	}
	
	function getStatsXML(){
		$xml.='<STATS>';
		$xml.= 	'<ROWS>'.$this->getRowsCount().'</ROWS>';
		$xml.= 	'<COLUMNS>'.$this->getColumnsCount().'</COLUMNS>';
		$xml.='</STATS>';
		return $xml;
	}
	
	function open(){
		$this->fp = @fopen($this->getCompletePath(),'r');
		return $this->fp;
	}
	
	function close(){
		if($this->fp)
			fclose($this->fp);
	}
	
	function getNextLine(){
		if(!$this->fp)
			$this->open();
		if($this->fp){
			$line = fgetcsv( $this->fp, 30000 , $this->separator , $this->enclosure );
			return $line;
		}else{
			return false;
		}
		
	}
	
	function getDefaultOutput(){
		$output = new Sushee_CSVOutput();
		$output->enableAllColumns();
		return $output;
	}
	
	function getColumnsXML($output = false){
		if(!$output){
			$output = $this->getDefaultOutput();
		}
		
		$xml.='<COLUMNS>';
		$fp = $this->open();
		if($fp){
			$line = $this->getNextLine();
			if(is_array($line)){
				$i = 1;
				foreach($line as $column){
					if($output->returnColumn($i)){
						$xml.='<COLUMN i="'.$i.'">'.encode_to_xml($column).'</COLUMN>';
					}
					
					$i++;
				}
			}
			$this->close();
		}
		$xml.='</COLUMNS>';
		return $xml;
	}
	
	function getRowsXML($output = false){
		if(!$output){
			$output = $this->getDefaultOutput();
		}
		
		$xml.='<ROWS>';
		$fp = $this->open();
		if($fp){
			$rowscount = 0;
			//skipping header
			if($this->hasHeader)
				$line = $this->getNextLine();
			while($line = $this->getNextLine()){
				$rowscount++;
				if($output->returnLine($rowscount)){
					$xml.='<ROW>';
					$i = 1;
					foreach($line as $cell){
						if($output->returnColumn($i)){
							$xml.='<CELL i="'.$i.'">'.encode_to_xml($cell).'</CELL>';
						}
						$i++;
					}
					$xml.='</ROW>';
				}
				if($output->isPageFinished($rowscount)){
					break;
				}
			}
			//$this->rowscount = $rowscount;
			$this->close();
		}
		$xml.='</ROWS>';
		return $xml;
	}
	
	function getColumnsCount(){
		if(!$this->columnscount){
			$fp = $this->open();
			if($fp){
				$line = $this->getNextLine();
				if($line){
					$this->columnscount = sizeof($line);
				}
				$this->close();
			}
		}
		
		return $this->columnscount;
	}
	
	function getRowsCount(){
		if(!$this->rowscount){
			$fp = $this->open();
			if($fp){
				$rowscount = -1; // first row does not count, this is the header
				while($line = $this->getNextLine()){
					$rowscount++;
				}
				$this->rowscount = $rowscount;
				$this->close();
			}
		}
		
		return $this->rowscount;
	}
}

?>