<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/common/movie.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/file.class.php");
require_once(dirname(__FILE__)."/../common/commandline.class.php");
require_once(dirname(__FILE__)."/../common/date.class.php");
require_once(dirname(__FILE__)."/../common/image.class.php");
class Movie extends File{
	
	function Movie($nectil_path){
		parent::File($nectil_path);
	}
	
	function getLength(){
		require_once(dirname(__FILE__)."/../common/getid3/getid3.php");
		$getID3 = new getID3;
		$file_info = $getID3->analyze($this->getCompletePath());
		getid3_lib::CopyTagsToComments($file_info);
		$time_unix = strtotime("00:".$file_info['playtime_string']);
		//$duration = date("H:i:s",$time_unix);
		$time = new Time();
		$time->addSeconds(date("s",$time_unix));
		$time->addMinutes(date("i",$time_unix));
		$time->addHours(date("H",$time_unix));
		return $time;
	}
}
class ImageMovieEffects extends FileEffects{
	function parseXMLNodes($effectsNodes){
		foreach($effectsNodes as $effectNode){
			$nodeName = $effectNode->nodeName();
			switch(strtolower($nodeName)){
				case 'resize':
					
					$newEffect = new ResizeImageEffect();
					$newEffect->setWidth($effectNode->valueOf('@width'));
					$newEffect->setHeight($effectNode->valueOf('@height'));
					$this->add($newEffect);
					break;
				case 'convert':
					$newEffect = new MovieImage();
					$newEffect->setTimecode($effectNode->valueOf('@timecode'));
					$this->add($newEffect);
					break;
				default:
			}
		}
	}
}

class MovieEffects extends FileEffects{
	
	var $effects;
	var $source;
	var $target;
	var $status;
	var $message;
	
	function MovieEffects(){
		$this->effects = array();
		$this->status = false;
	}
	
	function parseXMLNodes($effectsNodes){
		foreach($effectsNodes as $effectNode){
			$nodeName = $effectNode->nodeName();
			switch(strtolower($nodeName)){
				case 'resize':
					$newEffect = new MovieResize();
					$newEffect->setWidth($effectNode->valueOf('@width'));
					$newEffect->setHeight($effectNode->valueOf('@height'));
					$this->add($newEffect);
					break;
				case 'convert':
					
					$newEffect = new MovieConversion();
					$newEffect->setFormat($effectNode->valueOf('@format'));
					$newEffect->setCodec($effectNode->valueOf('@codec'));
					$newEffect->setBitrate($effectNode->valueOf('@bitrate'));
					$newEffect->setFps($effectNode->valueOf('@fps'));
					$newEffect->setMaxfilesize($effectNode->valueOf('@max-filesize'));
					$newEffect->setSize($effectNode->valueOf('@size'));
					$newEffect->setAudioCodec($effectNode->valueOf('@audio-codec'));
					$newEffect->setAudioFreq($effectNode->valueOf('@audio-freq'));
					$newEffect->setAudioBitrate($effectNode->valueOf('@audio-bitrate'));
					$newEffect->setAudioChannels($effectNode->valueOf('@audio-channels'));
					$this->add($newEffect);
					break;
				case 'cut':
					$newEffect = new MovieCut();
					$newEffect->setDuration($effectNode->valueOf('@duration'));
					$newEffect->setStart($effectNode->valueOf('@start'));
					$newEffect->setAudioBitrate($effectNode->valueOf('@audio-bitrate'));
					$this->add($newEffect);
					break;
				default:
			}
		}
	}
}

class MovieEffect extends SusheeObject{
	
	var $source;
	var $target;
	var $executable;
	var $status;
	var $message;
	
	function MovieEffect(){
		if(isset($GLOBALS["ffmpegExecutable"]))
			$this->executable = $GLOBALS["ffmpegExecutable"];
		else{
			$this->executable = 'ffmpeg';
		}
		
		$this->status = false;
	}
	
	function setSource(&$movie){
		$this->source = &$movie;
	}
	
	function setTarget(&$movie){
		$this->target = &$movie;
	}
	
	function execute(){}
	
	function getStatus(){
		return $this->status;
	}
	
	function getMessage(){
		return $this->message;
	}
}

class MovieResize extends MovieEffect{
	
	var $width;
	var $height;
	
	function MovieResize(){
		parent::MovieEffect();
	}
	
	function setWidth($width){
		$this->width = $width;
	}
	
	function setHeight($height){
		$this->height = $height;
	}
	
	function execute(){
		$options = 
			'-i "'.$this->source->getCompletePath().'"'
			.' -s '.$this->width.'x'.$this->height
			.' -y '.
			'"'.$this->target->getCompletePath().'"';
		$command = $this->executable.' '.$options;
		$command = &new CommandLine($command);
		$this->message = $command->execute();
		if(!$this->target->exists() || $this->target->getSize()==0){
			$this->status = false;
			$this->message = $command->getOutput();
		}else{
			$this->status = true;
			chmod_nectil($this->target->getCompletePath());
		}
		return $this->status;
	}
}

class MovieConversion extends MovieEffect{
	
	var $format;
	var $codec;
	var $bitrate;
	var $fps;
	var $maxfilesize;
	var $size;
	var $acodec;
	var $afreq;
	var $abitrate;
	var $achannels;
	
	function MovieConversion(){
		parent::MovieEffect();
	}
	
	function setFormat($format){
		$this->format = $format;
	}
	
	function setCodec($codec){
		$this->codec = $codec;
	}
	
	function setBitrate($bitrate){
		$this->bitrate = $bitrate;
	}
	
	function setFps($fps){
		$this->fps = $fps;
	}
	
	function setMaxfilesize($maxfilesize){
		$this->maxfilesize = $maxfilesize;
	}
	
	function setSize($size){
		$this->size = $size;
	}
	
	function setAudioCodec($acodec){
		$this->acodec = $acodec;
	}
	
	function setAudioFreq($afreq){
		$this->afreq = $afreq;
	}
	
	function setAudioBitrate($abitrate){
		$this->abitrate = $abitrate;
	}
	
	function setAudioChannels($achannels){
		$this->achannels = $achannels;
	}
	
	function execute(){
		$this->target->setExtension($this->format);
		$options = 
			'-i "'.$this->source->getCompletePath().'"';
		if($this->codec)
			$options.=' -vcodec '.$this->codec;
		if($this->bitrate)
			$options.=' -b '.$this->bitrate;
		if($this->fps)
			$options.=' -r '.$this->fps;
		if ($this->maxfilesize)
			$options .= ' -fs '.$this->maxfilesize;
		if($this->size)
			$options.=' -s '.$this->size;
		if($this->acodec)
			$options.=' -acodec '.$this->acodec;
		if($this->afreq)
			$options.=' -ar '.$this->afreq;
		if($this->abitrate)
			$options.=' -ab '.$this->abitrate;
		if($this->achannels)
			$options.=' -ac '.$this->achannels;
		$options.=' -y "'
			.$this->target->getCompletePath().'"';
		$command = $this->executable.' '.$options;
		$command = &new CommandLine($command);
		$this->message = $command->execute();
		if(!$this->target->exists() || $this->target->getSize()==0){
			$this->status = false;
			$this->message = $command->getOutput();
		}else{
			$this->status = true;
			chmod_nectil($this->target->getCompletePath());
		}
		return $this->status;
	}
}

class MovieCut extends MovieEffect{
	var $start;
	var $duration;
	var $abitrate= '192k';
	
	function setStart($start){
		$this->start = $start;
	}
	
	function setDuration($duration){
		$this->duration = $duration;
	}
	
	function setAudioBitrate($abitrate){
		if($abitrate !== false)
			$this->abitrate = $abitrate;
	}
	
	function execute(){
		$options = 
			'-i "'.$this->source->getCompletePath().'"';
		if($this->duration){
			$time = new Time($this->duration);
			$options.=' -t '.$time->getSQLTime();
		}
		if($this->abitrate){
			$options.=' -ab '.$this->abitrate;
		}
		if($this->start){
			$time = new Time($this->start);
			$options.=' -ss '.$time->getSQLTime();
		}
		$options.=' -y "'
			.$this->target->getCompletePath().'"';
		$command = $this->executable.' '.$options;
		$command = &new CommandLine($command);
		$this->message = $command->execute();
		if(!$this->target->exists() || $this->target->getSize()==0){
			$this->status = false;
			$this->message = $command->getOutput();
		}else{
			$this->status = true;
			chmod_nectil($this->target->getCompletePath());
		}
		return $this->status;
	}
}
 class MovieImage extends MovieEffect{
	var $timecode = false;
	function setTimecode($timecode){
		$this->timecode = $timecode;
	}
	
	function execute(){
		/*'-vcodec mjpeg -vframes 1 -ss 00:00:04  -an -f rawvideo';*/
		$this->target->setExtension('jpg');
		$options = 
			'-i "'.$this->source->getCompletePath().'"';
		$options.=' -vcodec mjpeg -vframes 1 ';
		if($this->timecode){
			if(strpos($this->timecode,':'))
				$options.=' -ss '.$this->timecode;
			else{
				$time = new Time($this->timecode);
				$options.=' -ss '.$time->getSQLTime();
			}
			
		}
		$options.=' -an -f rawvideo';
		$options.=' -y "'
			.$this->target->getCompletePath().'"';
		$command = $this->executable.' '.$options;
		$command = &new CommandLine($command);
		$this->message = $command->execute();
		if(!$this->target->exists() || $this->target->getSize()==0){
			$this->status = false;
			$this->message = $command->getOutput();
		}else{
			$this->status = true;
			chmod_nectil($this->target->getCompletePath());
		}
		return $this->status;
	}
}

?>