<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/common/nectil_publisher.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/nectil_object.class.php");
require_once(dirname(__FILE__).'/../common/nql.class.php');

class NectilPublisher extends SusheeObject{
	
	var $ns;
	
	function setNamespace($ns){
		$this->ns = $ns;
	}
	
	function getNamespace(){
		return $this->ns;
	}
	
	function authenticate($login,$password){
		$nql = new NQL(false);
		$nql->addCommand(
			'<GET>
				<WEBSERVICE url="http://nectil.com/'.Sushee_dirname.'/private/request.php" method="get">
					<PARAMS>
						<PARAM name="NQL">
							<QUERY>
								<SEARCH>
									<NECTIL:PUBLISHER>
										<INFO>
											<LOGIN operator="=">'.$login.'</LOGIN>
											<PASSWORD operator="encrypt">'.$password.'</PASSWORD>
										</INFO>
									</NECTIL:PUBLISHER>
									<RETURN>
										<INFO>
											<URI/>
											<NAMESPACE/>
										</INFO>
									</RETURN>
								</SEARCH>
							</QUERY>
						</PARAM>
					</PARAMS>
				</WEBSERVICE>
			</GET>');
		$nql->execute();
		$publisherDataNode = $nql->getElement('/RESPONSE/RESULTS/WEBSERVICE/RESPONSE/RESULTS/NECTIL:PUBLISHER');
		if(!$publisherDataNode){
			return false;
		}
		$publisherURI = $publisherDataNode->valueOf('INFO/URI');
		$publisherNamespace = $publisherDataNode->valueOf('INFO/NAMESPACE');
		
		$namespace = new SusheeNamespace($publisherNamespace,$publisherURI);
		$this->setNameSpace($namespace);
		
		return true;
	}
}

?>