<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/common/properties.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
/*-------------------------------------------------------------
			PROPERTIES
-------------------------------------------------------------*/
function createProperties(&$xml,$current_path,$IDs_array,&$moduleInfo,$elem_values=false){
	if ($moduleInfo->getServiceSecurity('property',$elem_values)!=='W')
		return false;//'No right to handle properties on this module.';
	$query_result = "";
	$db_conn = db_connect();
	$properties_array = $xml->match($current_path."/PROPERTIES");
	foreach($properties_array as $properties_path){
		$operation = $xml->getData($properties_path."/@operation");
		$names = array();
		if(!$operation)
			$operation = 'replace';
		$property_array = $xml->match($properties_path."/*");
		foreach($property_array as $property_path){
			$operator = $xml->getData($property_path."/@operator");
			$name = $xml->nodeName($property_path);
			$names[]=$name;
			if($operation == 'replace' || $operation == 'append'){
				$new_value = $xml->getData($property_path);
				$new_value = decode_from_XML($new_value);
				foreach($IDs_array as $ID){
					$property_sql = 'SELECT `Value` FROM `properties` WHERE `Denomination`="'.encodeQuote($name).'" AND `ModuleTargetID`=\''.($moduleInfo->ID).'\' AND `TargetID`=\''.$ID.'\';';
					$property_row = $db_conn->getRow($property_sql);
					if($property_row)
						$former_value =  $property_row['Value'];
					else
						$former_value = 0;
					if($operator){
						switch($operator){
							case '+':
								$new_value=$former_value+$new_value;
								break;
							case '-':
								$new_value=$former_value-$new_value;
								break;
							case '*':
								$new_value=$former_value*$new_value;
								break;
							case '/':
								if($new_value!=0)
								$new_value=$former_value/$new_value;
								break;
							case '++':
								$new_value=$former_value+1;
								break;
							case '--':
								$new_value=$former_value-1;
								break;
							default:
						}
						if(sizeof($IDs_array)==1)
							$operated_props.= '<'.$name.'">'.encode_to_XML($new_value).'</'.$name.'>';
					}
					if($property_row)
						$sql = 'UPDATE `properties` SET `Value`="'.encodeQuote($new_value).'" WHERE `Denomination`="'.encodeQuote($name).'" AND `ModuleTargetID`=\''.($moduleInfo->ID).'\' AND `TargetID`=\''.$ID.'\';';
					else
						$sql = 'INSERT INTO `properties`(`Denomination`,`ModuleTargetID`,`TargetID`,`Value`) VALUES("'.encodeQuote($name).'",\''.($moduleInfo->ID).'\',\''.$ID.'\',"'.encodeQuote($new_value).'");';
						
					$db_conn->Execute($sql);
					
				}
			}
		}
		
		if($operation == 'replace'){
			$names_ready = array();
			foreach($names as $name)
				$names_ready[] = '"'.encodeQuote($name).'"';
			$del_sql = 'DELETE FROM `properties` WHERE `ModuleTargetID`=\''.($moduleInfo->ID).'\' AND `TargetID` IN ('.implode(',',$IDs_array).')';
			if(sizeof($names_ready)>0)
				$del_sql.=' AND `Denomination` NOT IN('.implode(',',$names_ready).')';
			$db_conn->Execute($del_sql);
		}
		if(sizeof($names)>0 && $operation == 'remove'){
			$names_ready = array();
			foreach($names as $name)
				$names_ready[] = '"'.encodeQuote($name).'"';
			$del_sql = 'DELETE FROM `properties` WHERE `ModuleTargetID`=\''.($moduleInfo->ID).'\' AND `TargetID` IN ('.implode(',',$IDs_array).') AND `Denomination` IN('.implode(',',$names_ready).')';
			$db_conn->Execute($del_sql);
		}
	}
	if($operated_props)
		$query_result = '<PROPERTIES>'.$operated_props.'</PROPERTIES>';
	return $query_result;
}	
function deleteProperties($moduleTargetID,$targetID){
	$db_conn = db_connect();
	$sql = "DELETE FROM properties WHERE ModuleTargetID='$moduleTargetID' AND TargetID='$targetID';";
	$db_conn->Execute($sql);
	$query_result.=$sql;
	return $query_result;
}

function getProperties($moduleTargetID,$targetID){
	$db_conn = db_connect();
	if (is_numeric($targetID))
		$target_cond = "TargetID='$targetID'";
	else if(is_array($targetID)){
		$first = true;
		foreach($targetID as $ID=>$value){
			if($first!=true) $target_cond.=" OR ";
			else $first=false;
			$target_cond.="TargetID='".$ID."'";
		}
		$target_cond='('.$target_cond.')';
	}
	$sql = 'SELECT * FROM properties WHERE ModuleTargetID=\''.$moduleTargetID.'\' AND '.$target_cond.';';
	$rs = $db_conn->Execute($sql);
	return $rs;
}
function generatePropertyXML($row,$output='html'){
	$name = encode_to_xml($row['Denomination']);
	return '<'.$name.'>'.encode_to_xml($row['Value']).'</'.$name.'>';
}
?>