<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/common/timer.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/nectil_object.class.php");

/*

Class handling a global timer, allowing to measure sushee performance

*/
class Sushee_Timer extends Sushee_Object{
	
	static function start(){
		$GLOBALS["time_start"] = getmicrotime();
		$GLOBALS["steps"]=0;
		$GLOBALS["last_step"]= $GLOBALS["time_start"];
	}

	static function lap($message){
		$mtime = getmicrotime();
		$lap = ($mtime - $GLOBALS["last_step"]) . ' sec. / ' . ($mtime - $GLOBALS["time_start"]) .' sec. total';
		if ($message)
		{
			$lap = $message.': '.$lap;
		}
		$GLOBALS["tracker"][]= $lap;
		$GLOBALS["last_step"] = $mtime;
		$GLOBALS["steps"]++;
		return $mtime - $GLOBALS["time_start"];
	}
	
	static function toString(){
		return implode("\r\n",$GLOBALS["tracker"]);
	}
	
	static function toXML(){
		return '<track>'.implode("</track><track>",$GLOBALS["tracker"]).'</track>';
	}
	
}

function getTimer($message=FALSE){ // verbose parameter DEPRECATED
	return Sushee_Timer::lap($message);
}

?>