<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/createOmnilinktype.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');
require_once(dirname(__FILE__).'/../private/delete.inc.php');

class sushee_createOmnilinkstype extends NQLOperation{
	
	var $moduleID;
	var $denomination;
	var $tablename;
	
	function parse(){
		
		$this->moduleID = $this->firstNode->valueOf('/INFO/MODULEID');
		$this->denomination = $this->firstNode->valueOf('/INFO/DENOMINATION');
		$this->tablename = $this->firstNode->valueOf('/INFO/TABLENAME');
		
		if(!$this->moduleID){
			$this->setError('No moduleID was given');
			return false;
		}
		
		$type = sushee_OmnilinkType($this->denomination);
		if($type->loaded){
			$this->setError('A type with the same denomination `'.$this->denomination.'` already exists');
			return false;
		}
		
		return true;
	}
	
	function operate(){
		
		// creating in database
		$create = new createElement($this->getName(),$this->getOperationNode());
		$create->execute();
		$this->setMsg($create->getMsg());
		
		// type definition
		$type = sushee_OmnilinkType($create->getElementID());
		
		// clearing the type of the same module in session
		$types = new sushee_OmnilinkTypeSet($type->getModule()->getID());
		$types->clearInSession();
		
		return true;
	}
	
}



?>