<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/deleteDeptype.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');

class deleteDeptype extends NQLOperation{
	
	var $row;
	
	function parse(){
		$db_conn = db_connect();
		
		// verifying the datas
		$ID = $this->firstNode->getData("DEPENDENCYTYPE[1]/@ID");
		if (!$ID){
			$this->setError("ID of the dependencyType to delete was not given.");
			return false;
		}
		$sql = "SELECT * FROM `dependencytypes` WHERE `ID`=$ID;";
		$row = $db_conn->getRow($sql);
		if (!$row){
			$this->setError("The dependencyType with this ID was not found.");
			return false;
		}
		if($row['IsLocked']=="1"){
			$this->setError("The dependencyType with this ID is locked.");
			return false;
		}
		$this->row = $row;
		return true;
	}
	
	function operate(){
		
		
		$row = $this->row;
		$ID = $row['ID'];
		$returnTypeID = $row["ReturnTypeID"];

		// deleting the dependencies with these dependencyType(start & return)
		$depType = depType($ID);

		$depType->delete();

		$this->setSuccess("The dependencyType was deleted with all the concerned dependencies.");
		
		return true;
	}
}
?>
