<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/deleteLabel.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');

class sushee_deleteLabel extends NQLOperation{
	
	var $denomination = false;
	var $languageID = false;
	
	function parse(){
		$this->denomination = $this->firstNode->valueOf('@name');
		if (!$this->denomination){
			$this->setError("You haven't set a name for the label you want to delete.");
			return false;
		}
		
		$this->languageID = $this->firstNode->valueOf('@languageID');
		
		return true;
	}
	
	function operate(){
		$db_conn = db_connect();
			
		$sql_cond = 'FROM `labels` WHERE `Denomination`="'.encodeQuote(decode_from_XML($this->denomination)).'"';
		if($this->languageID){
			$sql_cond.=' AND `LanguageID`=\''.encode_for_db($this->languageID).'\'';
		}
		$check_sql = 'SELECT `Denomination` '.$sql_cond.' LIMIT 0,1';
		if(!$db_conn->getRow($check_sql)){
			$this->setError('No label with that name found');
			return false;
		}
		$delete_sql = 'DELETE '.$sql_cond;
		sql_log($delete_sql);
		$res = $db_conn->execute($delete_sql);
		if(!$res){
			$this->setError('Delete failed : '.$db_conn->errorMsg());
			return false;
		}
		$this->setSuccess('Delete successful');
		return true;
	}
	
}

?>
