<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/feedback.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
// common feedbacks if possible
require_once(dirname(__FILE__)."/../common/nectil_user.class.php");
require_once(dirname(__FILE__)."/../common/mail.class.php");
require_once(dirname(__FILE__)."/../common/sushee.class.php");
require_once(dirname(__FILE__)."/../common/nqlOperation.class.php");

class Sushee_createFeedback extends NQLOperation{
	
	var $ID = false;
	var $values = array();
	function parse(){
		$values = array();
		$user = new NectilUser();
		$request = $user->getSushee_Request();
		
		$values['UserLongName'] = $user->getField("FirstName")." ".$user->getField("LastName")." ".$user->getField("Email1");
		$values['Resident'] = $request->getResidentName();
		$values['CreationDate']=$request->getDateSQL();
		$values['UserAgent']=$user->getUserAgent();
		$values['IP']=$user->getIP();
		$values['provider']=$user->getProvider();
		
		$values['user'] = decode_from_XML($this->operationNode->valueOf("USER[1]"));
		$values['application'] = decode_from_XML($this->operationNode->valueOf("APPLICATION[1]"));
		$values['type'] = decode_from_XML($this->operationNode->valueOf("TYPE[1]"));
		$values['description'] = decode_from_XML($this->operationNode->valueOf("DESCRIPTION[1]"));
		$values['logs'] = decode_from_XML($this->operationNode->valueOf("LOGS[1]"));
		$values['FlashVersion']=decode_from_XML($this->operationNode->valueOf("FLASHVERSION[1]"));
		
		$this->setValues($values);
		return true;
	}
	
	function setValues($values){
		$this->values = $values;
	}
	
	function getValues(){
		return $this->values;
	}
	
	function operate(){
		// feedback datas
		$feedback = $this->getValues();
		// user datas
		$user = new Sushee_User();
		$email = $user->getField('Email1');
		$username = $user->getField('FirstName')." ".$user->getField('LastName');
		$sushee = new Sushee_Instance();
		
		$message="Client: ".$sushee->getUrl()."\n";
		$message.="User: ".$username." ".$email."\n";
		$message.= "Application : ".$feedback['application']."\n"."Report type : ".$feedback['type']."\n";
		$message.= "UserAgent : ".$feedback['UserAgent']."\n";
		$message.="---------------------------------------------------\n";
		$message.=$feedback['description'];
		$message.="\n\n---------------------------------------------------\n\nFlash version :".$feedback['FlashVersion'];
		
		$mail = new ServerMail();
		$mail->setSubject("New Feedback");
		$mail->setText($message);
		$mail->setSender($mail->formatMailAdress($email,$username));
		if($sushee->getAdminEmail()){
			$recipient = $sushee->getAdminEmail();
		}else{
			$recipient = 'feedback@nectil.com';
		}
		$mail->addRecipient($recipient);
		$mail->execute();
		$this->setSuccess("Your feedback was transmitted to the Sushee administrator");
		return true;
	}
	
	function getID(){
		return $this->ID;
	}
}
?>
