<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/getenum.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');

define('ENUM_NUMERIC',1);
define('ENUM_UPPER_ALPHA',2);
define('ENUM_LOWER_ALPHA',3);

class getEnum extends NQLOperation{
	var $start = 0;
	var $end = 10;
	var $step = 1;
	var $mode = ENUM_NUMERIC;
	function parse(){
		$start = $this->firstNode->valueOf('START');
		$end = $this->firstNode->valueOf('END');
		$step = $this->firstNode->valueOf('STEP');
		if($start===false || $start===''){
			$this->setError('Start is empty');
			return false;
		}
		if($end===false || $end===''){
			$this->setError('End is empty');
			return false;
		}
		if(!is_numeric($start) || !is_numeric($end)){
			$start = ord($start);
			$end = ord($end);
			if( $start < 97){
				$this->mode = ENUM_UPPER_ALPHA;
				$end = ord(strtoupper(chr($end)));
			}else{
				$this->mode = ENUM_LOWER_ALPHA;
				$end = ord(strtolower(chr($end)));
			}	
		}
		if($start > $end && ($step===false || $step>0)){
			if($step==false)
				$step = -1;
			elseif($step>0)
				$step = -$step;
		}
		$this->start = $start;
		$this->end = $end;
		if($step)
			$this->step = $step;
		return true;
	}
	
	function getItem($index){
		switch($this->mode){
			case ENUM_UPPER_ALPHA;
			case ENUM_LOWER_ALPHA:
				return chr($index);
				break;
			default: 
				return $index;
		}
	}
	
	function operate(){
		$xml = '';
		$attributes = $this->getOperationAttributes();
		$xml.='<RESULTS'.$attributes.'>';
		$xml.=		'<ENUM>';
		if($this->start > $this->end){
			for($i=$this->start;$i>=$this->end;$i+=$this->step){
				$xml.=		'<E>'.$this->getItem($i).'</E>';
			}
		}else{
			for($i=$this->start;$i<=$this->end;$i+=$this->step){
				$xml.=		'<E>'.$this->getItem($i).'</E>';
			}
		}
		
		$xml.=		'</ENUM>';
		$xml.='</RESULTS>';
		$this->xml = $xml;
		return true;
	}
	
	function getXML(){
		return $this->xml;
	}
	
	
}