<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/getmonths.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');

class getMonths extends NQLOperation{
	var $start = 1;
	var $end = 12;
	var $step = 1;
	var $languageID = false;
	function parse(){
		$start = $this->firstNode->valueOf('START');
		$end = $this->firstNode->valueOf('END');
		$step = $this->firstNode->valueOf('STEP');
		$languageID = $this->firstNode->valueOf('@languageID');
		if(!$languageID){
			if (isset($GLOBALS["NectilLanguage"]) && $GLOBALS['restrict_language'])
				$languageID = $GLOBALS["NectilLanguage"];
		}
		if($start===false || $start===''){
			$start = 1;
		}
		if($end===false || $end===''){
			$end = 12;
		}
		$this->start = $start;
		$this->end = $end;
		if($step)
			$this->step = $step;
		if($languageID)
			$this->languageID = $languageID;
		return true;
	}
	
	function pad($nb){
		if($nb===false)
			$nb = 0;
		if($nb<10){
			return '0'.((int)$nb);
		}else
			return $nb;
	}
	
	function getItem($index){
		$db_conn = db_connect(true);
		$xml ='<MONTH ID="'.$this->pad($index).'" index="'.$index.'"';
		if(date('m')==$index){
			$xml.=' current="true"';
		}
		$xml.='>';
		if($this->languageID && $this->languageID!='all'){
			$sql = 'SELECT * FROM `months` WHERE `ID` = \''.$index.'\' AND `LanguageID`="'.encodequote($this->languageID).'"';
		}else{
			$sql = 'SELECT * FROM `months` WHERE `ID` = \''.$index.'\'';
		}
		$rs = $db_conn->Execute($sql);
		while($row = $rs->FetchRow()){
			$xml.=	'<LABEL languageID="'.encode_to_xml($row['LanguageID']).'">'.$row['Label'].'</LABEL>';
			$xml.=	'<SHORT languageID="'.encode_to_xml($row['LanguageID']).'">'.$row['Short'].'</SHORT>';
			$abbrev = $row['Short'];
			if($row['Dot']==1){
				$abbrev.='.';
			}
			$xml.=	'<ABBREV languageID="'.encode_to_xml($row['LanguageID']).'">'.$abbrev.'</ABBREV>';
		}
		$xml.='</MONTH>';
		return $xml;
	}
	
	function operate(){
		$xml = '';
		$attributes = $this->getOperationAttributes();
		
		$xml.='<RESULTS'.$attributes.'>';
		for($i=$this->start;$i<=$this->end;$i+=$this->step){
			$xml.=		$this->getItem($i);
		}
		$xml.='</RESULTS>';
		$this->xml = $xml;
		return true;
	}
	
	function getXML(){
		return $this->xml;
	}
	
	
}
?>