<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/listMessage.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');

class Sushee_ListMessage extends RetrieveOperation{
	
	function parse(){
		return true;
	}
	
	function operate(){
		$shell = new Sushee_Shell();
		$shell->enableEntities(false);
		$shell->addCommand(
			'<SEARCH>
				<WEBACCOUNT>
					<INFO>
						<OWNERID>visitor</OWNERID>
					</INFO>
					<INFO>
						<OWNERID op="!=">visitor</OWNERID>
						<PUBLIC>R</PUBLIC>
					</INFO>
				</WEBACCOUNT>
				<RETURN>
					<INFO>
						<API/>
					</INFO>
				</RETURN>
			</SEARCH>');
			
		$shell->execute();
		$accounts = $shell->getElements('/RESPONSE/RESULTS/WEBACCOUNT');
		foreach($accounts as $account){
			switch($account->valueOf('INFO/API')){
				case 'twitter':
					$shell->addCommand(
						'<GET name="'.$this->getName().'">
							<WEBSERVICE method="get" url="https://api.twitter.com/1/statuses/user_timeline.xml">
								<WEBACCOUNT ID="'.$account->valueOf('@ID').'"/>
							</WEBSERVICE>
						</GET>');
			}
		}
		$shell->execute();
		
		$texts = $shell->getElements('/RESPONSE/RESULTS/WEBSERVICE//text');
	    foreach ($texts as $t)
	    {
	    	$tmp = $this->twitterify($t->valueOf('.'));
	    	$t->replaceValue($tmp);
	    }
		
		$this->setXML($shell->copyOf('/RESPONSE/RESULTS'));
		
		return true;
	}
	
	function twitterify($ret) 
	{
		$ret = preg_replace("#(^|[\n ])([\w]+?://[\w]+[^ \"\n\r\t< ]*)#", "\\1<a class=\"navigable\" href=\"\\2\">\\2</a>", $ret);
		$ret = preg_replace("#(^|[\n ])((www|ftp)\.[^ \"\t\n\r< ]*)#", "\\1<a class=\"navigable\" href=\"http://\\2\">\\2</a>", $ret);
		$ret = preg_replace("/@(\w+)/", "<a class=\"navigable\" href=\"http://twitter.com/\\1\">@\\1</a>", $ret);
		$ret = preg_replace("/#(\w+)/", "<a class=\"navigable\" href=\"http://search.twitter.com/search?q=#\\1\">#\\1</a>", $ret);
		return $ret;
	}
	
}



?>