<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/searchApplication.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');
require_once(dirname(__FILE__).'/../common/application.class.php');

class searchApplication extends RetrieveOperation{
	
	var $applicationID = false;
	
	function parse(){
		$this->applicationID = $this->firstNode->valueOf('@ID');
		return true;
	}
	
	function operate(){
		$xml = '';
		$attributes = $this->getOperationAttributes();
		$xml.='<RESULTS'.$attributes.'>';
		if($this->applicationID){
			if($this->applicationID >= 1024){
				$app = new CustomApplication($this->applicationID);
			}else{
				$app = new OfficialApplication($this->applicationID);
			}
			$xml.=$app->getXML();
		}else{
			$list = new ApplicationCollection();

			while($app = $list->next()){
				$xml.=$app->getXML();
			}
		}
		
		$xml.='</RESULTS>';
		$this->xml = $xml;
		return true;
	}
	
}

?>