<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/showRichText.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/common_functions.inc.php");
require_once(dirname(__FILE__)."/../common/nectil_user.class.php");
require_once(dirname(__FILE__)."/../common/nql.class.php");


class MailRichTextWHeadersPage extends SusheeObject{
	
	var $mail = false;
	var $ID = false;
	
	function MailRichTextWHeadersPage($ID){
		$this->ID = $ID;
	}
	
	function execute(){
		$user = new NectilUser();
		if($user->isAuthentified()){
			$nql = new NQL(false);
			$nql->addCommand(
				'<SEARCH name="mail-infos">
					<MAIL>
						<INFO>
							<ID>'.$this->ID.'</ID>
							<OWNERID>'.$user->getID().'</OWNERID>
						</INFO>
					</MAIL>
					<RETURN>
						<INFO>
							<TO/>
							<CC/>
							<FROM/>
							<RECEIVINGDATE/>
							<SUBJECT/>
							<PLAINTEXT/>
						</INFO>
					</RETURN>
				</SEARCH>');
			$nql->execute();
			echo $nql->transform(dirname(__FILE__).'/../templates/showRichText.xsl');
		}else{
			$this->log('User not authentified and trying to consult emails');
		}
	}
}

$page = new MailRichTextWHeadersPage($_GET['ID']);
$page->execute();

?>

