<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/translateString.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');
require_once(dirname(__FILE__).'/../common/translator.class.php');

class sushee_translateString extends RetrieveOperation{
	
	var $orig_lg = false;
	var $target_lg = false;
	
	function parse(){
		$this->orig_lg = $this->firstNode->valueOf('@from');
		$this->target_lg = $this->firstNode->valueOf('@to');
		if(!$this->orig_lg){
			$this->setError('No source language defined (attribute `from`)');
			return false;
		}
		if(!$this->target_lg){
			$this->setError('No target language defined (attribute `to`)');
			return false;
		}
		
		return true;
	}
	
	function operate(){
		
		$translator = new sushee_translator();
		$translator->setOriginLanguage($this->orig_lg);
		$translator->setTargetLanguage($this->target_lg);
		$translation = $translator->execute($this->firstNode->valueOf());
		
		$attributes = $this->getOperationAttributes();		
		
		$this->setXML('<RESULTS'.$attributes.'><STRING from="'.$this->orig_lg.'" to="'.$this->target_lg.'">'.encode_to_xml($translation).'</STRING></RESULTS>');
		
		return true;
	}
	
}
?>