<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/public/configuration.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

	<!--xsl:import href="common.xsl"/-->
	<!--xsl:import href="params.xsl"/-->
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
		
	<xsl:template match="/RESPONSE">	
	
		<html>
			<head>
				<title>Nectil Media - Configuration</title>
			</head>
			<body aLink="#003366" bgColor="#ffffff" leftMargin="0" link="#003366" text="#003366" topMargin="0" vLink="#003366" marginheight="10" marginwidth="10">
		
		
				<div>
					<h2>Media Languages</h2>
					<xsl:for-each select="RESULTS[@name='languages']/LANGUAGE">		
						<b><xsl:value-of select="UNIVERSAL"/></b><xsl:if test="PUBLISHED='1'">(Published)</xsl:if><br/>
					</xsl:for-each>	
				</div>
				
		
		
		
				<div>
					<h2>Media Configuration</h2>
					<xsl:for-each select="RESULTS[@name='mediatype']/MEDIATYPE">	

							<!--
							<xsl:for-each select="*">
								<xsl:value-of select="."/>
							</xsl:for-each>	
							-->
							<p>
							<b><xsl:value-of select="UNIQUENAME"/></b><br/>
							<xsl:if test="ISCOMPOSITE='1'">Is composite<br/></xsl:if>
							<xsl:if test="ISPUBLI='1'">Is Publication date sensitive<br/></xsl:if>
							<xsl:if test="ISEVENT='1'">Is Event date sensitive<br/></xsl:if>
							<xsl:if test="ISTEMPLATE='1'">Is Template sensitive<br/></xsl:if>
							<xsl:if test="ISPAGETOCALL='1'">Is Page to call sensitive<br/></xsl:if>
							<xsl:if test="CSSFILE!=''">Have a particular CSS<br/></xsl:if>
							</p>
							

					</xsl:for-each>
				</div>
				
				
				
				<div>
					<h2>Dependency Configuration</h2>
					<xsl:for-each select="RESULTS[@name='dependencytype']/DEPENDENCY_TYPE">	
							<b><xsl:value-of select="TYPE"/></b><br/>
					</xsl:for-each>
				</div>
				
			</body>
		</html>
		
	</xsl:template>
	
</xsl:stylesheet>