<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/modules/DependencyDetails.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <!-- parameters -->
    <xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]"/>
    <xsl:param name="startDep" select="$item/DEPENDENCYTYPE[@ID=/RESPONSE/URL/startID][1]" />
    <xsl:param name="returnDep" select="$item/DEPENDENCYTYPE[@ID!=$startDep/@ID]" />
    
    <xsl:param name="fromModule" select="/RESPONSE/RESULTS[@name='fromModule']/MODULE" />
    <xsl:param name="toModule" select="/RESPONSE/RESULTS[@name='toModule']/MODULE" />
    
   	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-elementdetails">
	    	<xsl:with-param name="element" select= "$item" />
	    	<xsl:with-param name="newElement" select="false()"/>
			<xsl:with-param name="title" select="$startDep/TYPE" />
			<xsl:with-param name="titlecssclass" select="'dependency'" />
    		<xsl:with-param name="tabsList">
				<xsl:text>details,Details;code,Source code;</xsl:text>
    		</xsl:with-param>
   		    <xsl:with-param name="displayOverviewTab" select="false()" />
	    	<xsl:with-param name="displayAdminTab" select="true()" />
    	</xsl:call-template>
    </xsl:template>
    
	<xsl:template name="panel-title">
		<xsl:value-of select="$startDep/TYPE" />
	</xsl:template>

	<!-- custom : tabs content -->
	<xsl:template name="panel-body-element-tabs-content">
		<xsl:param name="element" />
		<xsl:param name="newElement" />
		
		<!-- default tab : details -->
  		<xsl:call-template name="element-tabform-create">
			<xsl:with-param name="denom" select="'details'" />
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="content">
				<xsl:call-template name="element-tab-details">
					<xsl:with-param name="element" select="$element" />
					<xsl:with-param name="newElement" select="$newElement" />
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
		
		<!-- default tab : source code -->
  		<xsl:call-template name="element-tabform-create">
			<xsl:with-param name="denom" select="'code'" />
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="content">
				<xsl:call-template name="element-tab-code">
					<xsl:with-param name="element" select="$element" />
					<xsl:with-param name="newElement" select="$newElement" />
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<!-- custom : details form -->	
    <xsl:template name="element-tab-details">	
    	<input type="hidden" name="start-dep-ID" value="{$startDep/@ID}" />	
    	<xsl:if test="$returnDep">	
    		<input type="hidden" name="return-dep-ID" value="{$returnDep/@ID}" />
    	</xsl:if>	
    			
   		<xsl:call-template name="overview-line">
   			<xsl:with-param name="label" select="'From Module: '" />
   			<xsl:with-param name="value">
   				<xsl:value-of select="$startDep/@from" />
   			</xsl:with-param>
   		</xsl:call-template>
   		<xsl:call-template name="overview-line">
   			<xsl:with-param name="label" select="'To Module: '" />
   			<xsl:with-param name="value">
   				<xsl:value-of select="$startDep/@to" />
   			</xsl:with-param>
   		</xsl:call-template>
   		<xsl:call-template name="overview-line">
   			<xsl:with-param name="label" select="'Type: '" />
   			<xsl:with-param name="value">
				<xsl:choose>
					<xsl:when test="$returnDep">
						<xsl:choose>
							<xsl:when test="$startDep/TYPE=$returnDep/TYPE">
								<xsl:value-of select="//LIST[@name='DependencyTypes']/ITEM[@value='uturn']/@label" />
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="//LIST[@name='DependencyTypes']/ITEM[@value='art']/@label" />
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="//LIST[@name='DependencyTypes']/ITEM[@value='aow']/@label" />
					</xsl:otherwise>
				</xsl:choose>
   			</xsl:with-param>
   		</xsl:call-template>
   		
   		<xsl:call-template name="form-info-line">
   			<xsl:with-param name="label" select="'*Table: '" />
   			<xsl:with-param name="input">
   				<input type="text" id="table" name="table" value="dependencies" class="input-text required" />
			</xsl:with-param>
	    	<xsl:with-param name="extraLabel">
	    		Lorem Ipsum is simply dummy text of the printing and typesetting industry.
	    	</xsl:with-param>
	    	<xsl:with-param name="topLabel" select="true()" />   				
   		</xsl:call-template>
   		
        <tr>
            <td colspan="2">
		   		<fieldset id="start-fieldset" class="fieldsets">
		   			<legend>
		   				<xsl:value-of select="$startDep/@from" />
		   				<xsl:text> </xsl:text>
		   				<img src="{$systemImagesURL}/icons/dependencies/arrow-right.png" style="height: 16px; width: 16px; position: relative; top: 4px; margin: 0 0px 0 0px;"/>
		   				<xsl:text> </xsl:text>
		   				<xsl:value-of select="$startDep/@to" />
		  			</legend>
		  			<table class="dependencies">
				   		<xsl:call-template name="overview-line">
				   			<xsl:with-param name="label" select="'Name: '" />
				   			<xsl:with-param name="value" select="$startDep/TYPE" />
				   		</xsl:call-template>
				   		<xsl:call-template name="form-info-line">
				   			<xsl:with-param name="label" select="'Label: '" />
				   			<xsl:with-param name="input">
				   				<input type="text" id="start-dep-label" name="start-dep-label" value="{$startDep/DENOMINATION/LABEL[@languageID='shared']}" class="input-text" />
							</xsl:with-param>
				   		</xsl:call-template>
				   		<xsl:call-template name="form-info-line">
				   			<xsl:with-param name="label" select="'Search Label: '" />
				   			<xsl:with-param name="input">
				   				<input type="text" id="start-dep-searchlabel" name="start-dep-searchlabel" value="{$startDep/DENOMINATION/SEARCHLABEL[@languageID='shared']}" class="input-text" />
							</xsl:with-param>
					    	<xsl:with-param name="extraLabel">
					    		Lorem Ipsum is simply dummy text of the printing and typesetting industry.
					    	</xsl:with-param>
					    	<xsl:with-param name="topLabel" select="true()" />  
				   		</xsl:call-template>
		  			</table>
		   		</fieldset>
	   		</td>
   		</tr>
   		<xsl:if test="$returnDep">
	        <tr>
	            <td colspan="2">
			   		<fieldset id="return-fieldset" class="fieldsets">
			   			<legend>   				
				   			<xsl:value-of select="$returnDep/@from" />
				   			<xsl:text> </xsl:text>
			   				<img src="{$systemImagesURL}/icons/dependencies/arrow-right-blue.png" style="height: 16px; width: 16px; position: relative; top: 4px; margin: 0 0px 0 0px;"/>  
			   				<xsl:text> </xsl:text> 				
			   				<xsl:value-of select="$returnDep/@to" />
			  			</legend>
			  			<table class="dependencies">
					   		<xsl:call-template name="overview-line">
					   			<xsl:with-param name="label" select="'Name: '" />
					   			<xsl:with-param name="value" select="$returnDep/TYPE" />
					   		</xsl:call-template>
					   		<xsl:call-template name="form-info-line">
					   			<xsl:with-param name="label" select="'Label: '" />
					   			<xsl:with-param name="input">
					   				<input type="text" id="return-dep-label" name="return-dep-label" value="{$returnDep/DENOMINATION/LABEL[@languageID='shared']}" class="input-text" />
								</xsl:with-param>
					   		</xsl:call-template>
					   		<xsl:call-template name="form-info-line">
					   			<xsl:with-param name="label" select="'Search Label: '" />
					   			<xsl:with-param name="input">
					   				<input type="text" id="return-dep-searchlabel" name="return-dep-searchlabel" value="{$returnDep/DENOMINATION/SEARCHLABEL[@languageID='shared']}" class="input-text" />
								</xsl:with-param>
						    	<xsl:with-param name="extraLabel">
						    		Lorem Ipsum is simply dummy text of the printing and typesetting industry.
						    	</xsl:with-param>
						    	<xsl:with-param name="topLabel" select="true()" />  
					   		</xsl:call-template>
			  			</table>
			   		</fieldset>
		   		</td>
	   		</tr>
   		</xsl:if>
	    
	    <xsl:call-template name="form-info-line-submit">
	    	<xsl:with-param name="input">
				<input type="submit" name="submit" class="input-submit-save" value="Update"/>
			</xsl:with-param>
	    </xsl:call-template>
    </xsl:template>
    
    <!-- custom : code tab -->
    <xsl:template name="element-tab-code">
        <xsl:param name="element" />  
        
        <xsl:call-template name="form-line">
        	<xsl:with-param name="content">
        		<xsl:text>Copy and paste the following XSL code in your stylesheet to add a navigation item to the elements in dependency:</xsl:text>
        	</xsl:with-param>
        </xsl:call-template>
        <xsl:call-template name="form-empty-line" />
        
	  	<xsl:call-template name="form-info-line">
		    <xsl:with-param name="label" select="'Detail navitem code: '" />
		    <xsl:with-param name="input">
		    	<textarea class="input-textarea" style="height:250px;">
		    		<xsl:apply-templates select="/RESPONSE/RESULTS[@name='sourceXSLLink']/node()" mode="multiline" />
		    	</textarea>
		    </xsl:with-param>
	    </xsl:call-template>
    </xsl:template>
    
	<!-- custom form js -->
	<xsl:template name="element-form-js">
		<xsl:param name="element" />
		<xsl:param name="newElement" />
		<xsl:param name="tabDenom" />
		<xsl:param name="addInputsValidation" select="true()" />
		<xsl:param name="processingMsg" />
		<xsl:param name="newPanelTitle" />
		
		<xsl:variable name="formID">
			<xsl:call-template name="gen-tabID">
				<xsl:with-param name="denom" select="$tabDenom" />
			</xsl:call-template>
		</xsl:variable>
		
		<!-- inputs validation -->
		var inputsValidator<xsl:value-of select="$panelID"/> = new InputsValidator(<xsl:value-of select="$panelID"/>, '#<xsl:value-of select="$formID" />');
	
	        $('#<xsl:value-of select="$formID" />').submit(function() {
	          	fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
	          	fm.onSuccess(function(response){
	               <xsl:text>$(AppController).panelslider('refreshPanel', </xsl:text>
	                   <xsl:value-of select="$panelID"/>
                   <xsl:text>);</xsl:text>
				});					
				fm.setScript('<xsl:value-of select="$appsURL" /><xsl:text>sushee/shared/dependency/dependency-ops.php?op=update</xsl:text>');
				fm.displayProcess('Updating dependency...');	
				
				// makes a cleanup and moves the content from the editor to the form field
	            if (tinyMCE) tinyMCE.triggerSave();  
	            
				fm.parseAndSend(this);		
				return false;
	        });
	</xsl:template>
	
	<!-- custom : details navigation -->
    <xsl:template name="panel-block-details-nav-element">
    	<xsl:param name="element" />
    	
        <xsl:call-template name="navigationdetailsitem">
            <xsl:with-param name="title">Target Module</xsl:with-param>
            <xsl:with-param name="app">
            	<xsl:apply-templates select="$toModule" mode="element-application"/>
			</xsl:with-param>
            <xsl:with-param name="editor">
            	<xsl:apply-templates select="$toModule" mode="element-application-editor"/>
			</xsl:with-param>
            <xsl:with-param name="panelURI">
            	<xsl:apply-templates select="$toModule" mode="element-script-detail"/>
			</xsl:with-param>
            <xsl:with-param name="params">
            	<xsl:apply-templates select="$toModule" mode="element-navitem-parms"/>
			</xsl:with-param>
            <xsl:with-param name="cssclass">first</xsl:with-param>
        </xsl:call-template>
        <xsl:call-template name="navigationdetailsitem">
            <xsl:with-param name="title">Source Module</xsl:with-param>
            <xsl:with-param name="app">
            	<xsl:apply-templates select="$fromModule" mode="element-application"/>
			</xsl:with-param>
            <xsl:with-param name="editor">
            	<xsl:apply-templates select="$fromModule" mode="element-application-editor"/>
			</xsl:with-param>
            <xsl:with-param name="panelURI">
            	<xsl:apply-templates select="$fromModule" mode="element-script-detail"/>
			</xsl:with-param>
            <xsl:with-param name="params">
            	<xsl:apply-templates select="$fromModule" mode="element-navitem-parms"/>
			</xsl:with-param>
            <xsl:with-param name="cssclass">
            	<xsl:text>last</xsl:text>
            </xsl:with-param>
        </xsl:call-template>	
    </xsl:template>
    
        <!-- custom : admin content -->
	<xsl:template name="element-tab-admin">
        <xsl:param name="element" />
        <xsl:param name="deleteRight" />     
        <input type="hidden" name="start-dep-ID" value="{$startDep/@ID}" />	
    	<xsl:if test="$returnDep">	
    		<input type="hidden" name="return-dep-ID" value="{$returnDep/@ID}" />
    	</xsl:if>	

		<xsl:call-template name="overview-line">
			<xsl:with-param name="label" select="'Element:'" />
			<xsl:with-param name="value">
                <xsl:text>DEPENDENCYTYPE </xsl:text>
                <xsl:value-of select="$startDep/TYPE"></xsl:value-of>
                <xsl:text> (</xsl:text>
                <xsl:value-of select="$startDep/@ID" />
                <xsl:text>)</xsl:text>
                <xsl:if test="$returnDep">
                	<br />
	                <xsl:text>DEPENDENCYTYPE </xsl:text>
	                <xsl:value-of select="$returnDep/TYPE"></xsl:value-of>
	                <xsl:text> (</xsl:text>
	                <xsl:value-of select="$returnDep/@ID" />
	                <xsl:text>)</xsl:text>
                </xsl:if>
			</xsl:with-param>
			<xsl:with-param name="topLabel" select="true()" />
		</xsl:call-template>
		
		<xsl:call-template name="form-empty-line" />
		<xsl:call-template name="overview-line">
			<xsl:with-param name="label" select="'Editor:'" />
			<xsl:with-param name="value">
                <xsl:value-of select="/RESPONSE/URL/editorName"/>
			</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="overview-line">
			<xsl:with-param name="label" select="'Application:'" />
			<xsl:with-param name="value">
                <xsl:value-of select="/RESPONSE/URL/appName"/>
			</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="overview-line">
			<xsl:with-param name="label" select="'Panel:'" />
			<xsl:with-param name="value">
                <xsl:value-of select="/RESPONSE/URL/editor"/>
                <xsl:text>/</xsl:text>
                <xsl:value-of select="/RESPONSE/URL/app"/>
                <xsl:text>/</xsl:text>
                <xsl:value-of select="/RESPONSE/URL/panelURI"/>
                <xsl:text> (#</xsl:text>
                <xsl:value-of select="$panelID" />
                <xsl:text>)</xsl:text>
			</xsl:with-param>
		</xsl:call-template>
		
         <xsl:if test="boolean($deleteRight)=true()">
             <xsl:call-template name="form-delete-line-submit" />
        </xsl:if>
    </xsl:template>
    
	<!-- custom : admin js -->
	<xsl:template name="panel-js-element-admin">
		<xsl:param name="element" />
		<xsl:param name="adminDenom" />
		
		<xsl:variable name="adminFormID">
			<xsl:call-template name="gen-tabID">
				<xsl:with-param name="denom" select="$adminDenom" />
			</xsl:call-template>
		</xsl:variable>
	
            $('#<xsl:value-of select="$adminFormID" />').find('.input-submit-remove').click(function() {
                fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);

				fm.onSuccess(function(response){
                    $(AppController).panelslider('removePanel', <xsl:value-of select="$panelID"/>, 1);
				});

                fm.displayProcess('Deleting dependency...');
                fm.setScript('<xsl:value-of select="$appsURL" /><xsl:text>sushee/shared/dependency/dependency-ops.php?op=delete</xsl:text>');
				fm.parseAndSend($('#<xsl:value-of select="$adminFormID" />'));

				return false;
            });
	</xsl:template>
</xsl:stylesheet>