<?xml version="1.0" encoding="UTF-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/modules/export-field.nql.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>

	<xsl:template match="/RESPONSE">
	    <QUERY>
		    <xsl:apply-templates select="/RESPONSE/RESULTS/FIELD" mode="nql-update"/>
		</QUERY>
	</xsl:template>
	
	<xsl:template match="FIELD" mode="nql-update">
		<UPDATE>
			<FIELD denomination="{INFO/DENOMINATION}" module="{INFO/MODULE}">
				<INFO>
					<SEARCHABLE><xsl:value-of select="INFO/SEARCHABLE" /></SEARCHABLE>
					<xsl:if test="INFO/TYPE='list' or INFO/TYPE='systemList'">
    					<TYPE><xsl:value-of select="INFO/TYPE" /></TYPE>
    					<LISTNAME><xsl:value-of select="INFO/LISTNAME" /></LISTNAME>
					</xsl:if>
					<xsl:if test="INFO/TYPE='boolean' or INFO/TYPE='file'">
    					<TYPE><xsl:value-of select="INFO/TYPE" /></TYPE>
					</xsl:if>
				</INFO>
				<DESCRIPTIONS>
				    <xsl:for-each select="DESCRIPTIONS/DESCRIPTION">
    				    <xsl:if test="TITLE/text()">
        					<DESCRIPTION languageID="{@languageID}">
        						<TITLE>
        							<xsl:value-of select="TITLE"/>
        						</TITLE>
        					</DESCRIPTION>
    				    </xsl:if>
    			    </xsl:for-each>
			    </DESCRIPTIONS>
			</FIELD>
		</UPDATE>
	</xsl:template>

</xsl:stylesheet>