<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/publish/Publish.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <xsl:param name="publishFormID">
    	<xsl:text>publish-form-</xsl:text>
    	<xsl:value-of select="$panelID" />
    </xsl:param>
    
    <xsl:param name="list" select="/RESPONSE/RESULTS[@name='list']" />

	<xsl:template match="/RESPONSE">
		<xsl:call-template name="panel-navigation">
		</xsl:call-template>
	</xsl:template>
	
    <!-- navigation header -->
	<xsl:template name="panel-header-navigation">
		<xsl:attribute name="class">
			<xsl:text>panel-header publish-header</xsl:text>
		</xsl:attribute>
		<form id="{$publishFormID}" class="publish-form">
			<input type="hidden" name="originEnv" value="{/RESPONSE/URL/originEnv}" />
			<input type="hidden" name="targetEnv" value="{/RESPONSE/URL/targetEnv}" />
			
			<table width="100%">
				<tr>
					<td>
						<label>Release comment:</label><br />
						<textarea class="input-textarea" name="release-comment"></textarea>
					</td>
					<td>
						<input type="submit" value="Publish!" class="input-submit-save" />
					</td>
				</tr>
			</table>
		</form>
	</xsl:template>
	
	<!-- navigation body -->
	<xsl:template name="panel-body-navigation">
        <xsl:choose>
            <xsl:when test="$list/@hits > 0">
	            <xsl:apply-templates select="$list/NAMESPACE" mode="browse">
	            	<xsl:sort select="INFO/EDITOR" /> 
	            </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <div class="no-result">
                	<xsl:text>No editors found! Please check installation.</xsl:text>
                </div>
            </xsl:otherwise>
        </xsl:choose>
		<xsl:call-template name="staticitem-check">
			<xsl:with-param name="id">
               <xsl:text>system</xsl:text>
           </xsl:with-param>
			<xsl:with-param name="title" select="'System'" />
			<xsl:with-param name="icon">
			</xsl:with-param>
			<xsl:with-param name="info" select="'System resources'" />
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="NAMESPACE" mode="browse">
		<xsl:apply-templates select="." mode="element-navitem-check">
			<!--xsl:with-param name="disabled" select="boolean(not(DEPENDENCIES/DEPENDENCY[@type='officity:namespaceApps']/APP))" /-->
		</xsl:apply-templates>
		<!--xsl:choose>
			<xsl:when test="DEPENDENCIES/DEPENDENCY[@type='officity:namespaceApps']/APP"-->
				<xsl:call-template name="staticitem-check">
					<xsl:with-param name="id">
		               <xsl:text>shared-</xsl:text>
		               <xsl:apply-templates select="." mode="element-navitem-id"/>
		           </xsl:with-param>
				  	<xsl:with-param name="cssclass">
				  		<xsl:text>group-</xsl:text>
				  		<xsl:apply-templates select="." mode="element-navitem-id"/>
				  		<xsl:text> shared</xsl:text>
				  	</xsl:with-param>
					<xsl:with-param name="title">
						<span style="font-style:italic;">Shared resources</span>
					</xsl:with-param>
					<xsl:with-param name="icon">
					</xsl:with-param>
					<xsl:with-param name="tab" select="true()"/>
					<!--xsl:with-param name="disabled" select="true()"/-->
				</xsl:call-template>
				<xsl:apply-templates select="DEPENDENCIES/DEPENDENCY[@type='officity:namespaceApps']/APP" mode="element-subnavitem-check">
					<xsl:sort select="INFO/DENOMINATION" />
				</xsl:apply-templates>
			<!--/xsl:when>
			<xsl:otherwise-->
				<!--xsl:call-template name="staticitem">
					<xsl:with-param name="title">
						<span style="font-style:italic; color:#666;">No applications</span>
					</xsl:with-param>
					<xsl:with-param name="cssclass" select="''" />
				</xsl:call-template-->
			<!--/xsl:otherwise>
		</xsl:choose-->
	</xsl:template>
	
	<xsl:template name="panel-add-js">	
		<xsl:param name="element" select="/RESPONSE/RESULTS/OFFICITY:RELEASE" />
		<xsl:call-template name="js-init-autoresize" />
		
		// editor checkboxes
		$('#<xsl:value-of select="$panelID" />.panel').find('.items:not(.subitems)').find('input:checkbox').click(function(){
			var item = $(this).closest('.items');
			if ($(this).is(':checked'))
			{
				item.nextAll('.subitems.group-'+item.attr('id')).find('input:checkbox').attr('checked','checked');
			}
			else
			{
				item.nextAll('.subitems.group-'+item.attr('id')).find('input:checkbox').removeAttr('checked');
			}
		});
		
		// app checkboxes
		$('#<xsl:value-of select="$panelID" />.panel').find('.subitems').find('input:checkbox').click(function(){
			var editorItem = $(this).closest('.items').prevAll('.items:not(.subitems)').eq(0);
			if ($(this).is(':checked'))
			{
				editorItem.find('input:checkbox').attr('checked','checked');
				editorItem.next('.shared').find('input:checkbox').attr('checked','checked');
			}
			else
			{
				if (editorItem.nextAll('.subitems.group-'+editorItem.attr('id')+':not(.shared)').find('input:checked').length == 0)
				{
					editorItem.find('input:checkbox').removeAttr('checked');
					editorItem.next('.shared').find('input:checkbox').removeAttr('checked');
				}
			}
		});
		
		// publishing
		$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$publishFormID" />').submit(function(){
               fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
               
               fm.onSuccess(function(response){
				   var elemLabel = (response.label) ? response.label : 'New release';
	               <xsl:text>$(AppController).panelslider('replacePanel', </xsl:text>
	                   <xsl:value-of select="$panelID"/>
	                   <xsl:text>,'</xsl:text>
	                   <xsl:apply-templates select="$element" mode="element-script-detail"/>
	                   <xsl:text>',elemLabel,</xsl:text>
	                   <xsl:text>{editor:'</xsl:text>
	                   <xsl:apply-templates select="$element" mode="element-application-editor"/>
	                   <xsl:text>',app:'</xsl:text>
	                   <xsl:apply-templates select="$element" mode="element-application"/>
	                   <xsl:text>',module:response.module,ID:response.ID}</xsl:text>
	               <xsl:text>, 1);</xsl:text>
               });

			fm.displayProcess('Publishing...');
            fm.setScript('<xsl:value-of select="$appURL" />publish/publish-ops.php');
            fm.parse(this);
            
			$('#<xsl:value-of select="$panelID" />.panel').find('input:checkbox').each(function() {	
				if ($(this).attr('checked') == true)
				{
					fm.addData($(this).attr('name'), '1');
				}
			});

			fm.addData('op', 'publishApps')
			fm.send();
            return false;
		});
	</xsl:template>
</xsl:stylesheet>