<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/lib/documents/ChapterContent.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
    require_once(dirname(__FILE__).'/include.php');
    
    /* *** */
    
    $nql = new Officity_Shell();
    
    $CONTAINER_ID = URLParam::fetch('ID');
    $container = new Officity_LibitemElement($CONTAINER_ID);    
        	
   	$return_infos = array(
		'INFO/TITLE',
		'INFO/TYPE',
		'INFO/SIZE',
		'INFO/SIZEHUMAN',
		'INFO/ITEMS',
		'INFO/ITEMSTOTAL',
   		'INFO/DISPLAY',
   		'INFO/TRASHED',
   		'DESCRIPTION/TITLE',
   		'DESCRIPTION/SUMMARY'
    );
	$container->setReturn($return_infos, 1);
    $container->get('item', false);
    $nql_command = $container->getNQLCommand();
    $nql->addCommand($nql_command);

    if (URLParam::isNotEmpty('quicksearch-text'))
    {
    	// set display mode
    	$nql->addParam2XML('mode', 'searchitems');
    	
    	$nql->addPaging();
    	
    	$items = new Officity_LibitemElement();
    	
    	$items->setReturn($return_infos, 1);
    	$items->setAncestorByElement($container, 'officity:content');
    	$items->addSearchInfo('SEARCHTEXT', 'MATCH', URLParam::fetch('quicksearch-text'));
    	$items->addSearchInfo('TYPE', '=', 'page');

	    $items->setDefaultPaginate(50, URLParam::fetch('page', 1));		    		    
		$items->search('list', false);
		$search_command = $items->getNQLCommand();
    }
    else
    {
    	$search_command = '
    		<GETCHILDREN name="list" type="officity:content">
	            <OFFICITY:LIBITEM ID="'.$CONTAINER_ID.'" />
	            <RETURN>
	                <INFO>
						<TITLE />
						<TYPE />
						<KIND /> 
						<SIZE />
						<SIZEHUMAN />
						<TRASHED />
	                </INFO>
					<DESCRIPTIONS>
						<DESCRIPTION>
							<TITLE />
							<SUMMARY />
						</DESCRIPTION>
					</DESCRIPTIONS>
	            </RETURN>
    		</GETCHILDREN>
    	';    	
    }

    $nql->addCommand($search_command);	    
	
    echo $nql->transform(dirname(__FILE__).'/ChapterContent.xsl');
?>