<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/lib/documents/DiskContent.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <xsl:param name="container" select="/RESPONSE/RESULTS[@name='item']/OFFICITY:LIBITEM" />
    <xsl:param name="list" select="/RESPONSE/RESULTS[@name='list']" />
    <xsl:param name="items" select="$list/OFFICITY:LIBITEM[INFO/TRASHED='no']" />
    
    <!-- IDs -->
    <xsl:param name="quickAddFolderFormID">
        <xsl:text>header-folderform-</xsl:text><xsl:value-of select="$panelID" />
    </xsl:param>

	<xsl:template match="/RESPONSE">	
    	<xsl:call-template name="panel-quicksearch">
			<xsl:with-param name="list" select="/RESPONSE/RESULTS[@name='list']"/>
			<xsl:with-param name="module" select="'officity:libitem'" />
			<xsl:with-param name="pagingStyle" select="'pager'"/>
	        <xsl:with-param name="addNew" select="false()" />  
	        <xsl:with-param name="params">
				<xsl:text>ID:</xsl:text>
				<xsl:value-of select="$container/@ID" />
	        </xsl:with-param>
    	</xsl:call-template>
    </xsl:template>

	<!-- custom : header -->
	<xsl:template name="panel-header-quicksearch">
		<form id="quichsearch-form" onsubmit="return false;" style="width:25%">
			<xsl:call-template name="header-quicksearch-input">
				<xsl:with-param name="ID">
					<xsl:text>quicksearch-text</xsl:text>
				</xsl:with-param>
				<xsl:with-param name="searchText" select="'Quick search...'" />
				<xsl:with-param name="resetID">
					<xsl:text>quicksearch-reset</xsl:text>
				</xsl:with-param>
			</xsl:call-template>
		</form>
		
		<form id="{$quickAddFolderFormID}" name="{$quickAddFolderFormID}" class="quickadd-form" style="width:25%">
  			<input type="hidden" value="folder">
				<xsl:attribute name="name">
					<xsl:call-template name="gen-info-input-name">
						<xsl:with-param name="moduleName" select="'officity:libitem'" />
						<xsl:with-param name="fieldName" select="'TYPE'" />
					</xsl:call-template>
				</xsl:attribute>
   			</input>
			<input type="hidden" name="dependency" value="officity:content" />
			<input type="hidden" name="targetModule" value="officity:libitem" />
			<input type="hidden" name="targetID" value="{$container/@ID}" />
			<xsl:call-template name="header-input">
				<xsl:with-param name="name">
					<xsl:call-template name="gen-info-input-name">
						<xsl:with-param name="moduleName" select="'officity:libitem'" />
						<xsl:with-param name="fieldName" select="'TITLE'" />
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="ID">
					<xsl:call-template name="gen-info-input-ID">
						<xsl:with-param name="moduleName" select="'officity:libitem'" />
						<xsl:with-param name="fieldName" select="'TITLE'" />
					</xsl:call-template>
					<xsl:text>-quickadd</xsl:text>
				</xsl:with-param>
				<xsl:with-param name="addText" select="'New folder(s)...'" />
				<xsl:with-param name="imgcssclass" select="'img-folder'" />
			</xsl:call-template>
		</form>
		
		<!-- see include.xsl -->
		<xsl:call-template name="form-actions">
			<xsl:with-param name="container" select="$container"/>
		</xsl:call-template>
	</xsl:template>
	
	<!-- custom : list -->
	<xsl:template name="panel-list-quicksearch">  
		<xsl:param name="list" />
	
		<!--  see include.xsl -->	
		<xsl:call-template name="container-details-item">
			<xsl:with-param name="container" select="$container" />
			<xsl:with-param name="containerName" select="'disk'" />
			<xsl:with-param name="itemsCount" select="count($items)" />
		</xsl:call-template>
		
		<xsl:choose>  
			<xsl:when test="$items">
				<xsl:choose>
					<xsl:when test="/RESPONSE/URL/mode='searchitems'">
						<xsl:for-each select="$items" >			
							<xsl:sort select="INFO/TYPE='page'" />
							<xsl:sort select="INFO/TYPE='chapter'" />
							<xsl:sort select="INFO/TYPE='book'" />
							<xsl:sort select="INFO/TYPE='file'" />
							<xsl:sort select="INFO/TYPE='folder'" />
							<xsl:sort select="INFO/KIND" />
							<xsl:sort select="INFO/TITLE" />
							<xsl:apply-templates select="." mode="element-navitem" />
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="choose-draggable-navigation">
							<xsl:with-param name="items" select="$items" />
							<xsl:with-param name="container" select="$container" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="/RESPONSE/URL/mode='searchitems'">
						<div class="no-result">No hits</div>
					</xsl:when>
					<xsl:otherwise>
						<div class="no-result">This disk is empty</div>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='folder' or INFO/TYPE='book' or INFO/TYPE='chapter']" mode="element-script-detail">
		<xsl:apply-templates select="." mode="element-script-content"/>
	</xsl:template>
	
	<!-- custom : additional js -->
	<xsl:template name="panel-add-js">
		<!-- see include.xsl -->
		<xsl:call-template name="init-panel-header-actions-js" />
		
        <!-- quick add folder -->
		<xsl:call-template name="init-panel-header-quickadd-js">
			<xsl:with-param name="formID" select="$quickAddFolderFormID" /> 
			<xsl:with-param name="container" select="$container" />
			<xsl:with-param name="processingMsg" select="'Adding new folder(s)...'" /> 
		</xsl:call-template>
	</xsl:template>
</xsl:stylesheet>