<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/lib/documents/FileNew.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <!-- parameters -->
    <xsl:param name="fields" select="/RESPONSE/RESULTS[@name='fields']/FIELD"/>
    <xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]"/>
    <xsl:param name="module" select="/RESPONSE/URL/module"/>    
    <xsl:param name="categories" select="/RESPONSE/RESULTS/CATEGORY"/>
        
    <!-- optional -->
    <xsl:param name="dependency" select="/RESPONSE/URL/dependency"/>
    <xsl:param name="targetModule" select="/RESPONSE/URL/targetModule"/>
    <xsl:param name="targetID" select="/RESPONSE/URL/targetID"/>
    
   	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-newelement">
    		<xsl:with-param name="element" select= "$item" />
    		<xsl:with-param name="title" select= "'New file'" />
    		<xsl:with-param name="tabsList" select= "'info,Info;'" />
    		<xsl:with-param name="titlecssclass" select="'officity__libitem-file'"/>
    	</xsl:call-template>
    </xsl:template>
    
    <!-- custom : tabs content -->
	<xsl:template name="panel-body-element-tabs-content">
		<xsl:param name="element" />
		<xsl:param name="newElement" />
		
		<!-- tab : info -->
  		<xsl:call-template name="element-tabform-create">
			<xsl:with-param name="denom" select="'info'" />
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="content">
				<xsl:call-template name="element-tab-info">
					<xsl:with-param name="element" select="$element" />
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
    
    <!-- custom : info form -->
    <xsl:template name="element-tab-info">
        <xsl:param name="element" />  
		<input type="hidden" value="file">
			<xsl:attribute name="name">
				<xsl:apply-templates select="$element/INFO/TYPE" mode="gen-info-input-name" />
			</xsl:attribute>
		</input>
        
		<!-- optional : use for creating new elements in dependency -->
		<xsl:if test="$dependency">
			<input type="hidden" id="dependency" name="dependency" value="{$dependency}" />
		</xsl:if>
		<xsl:if test="$targetModule">
			<input type="hidden" id="targetModule" name="targetModule" value="{$targetModule}" />
		</xsl:if>
		<xsl:if test="$targetID">
			<input type="hidden" id="targetID" name="targetID" value="{$targetID}" />
		</xsl:if>
   
        <xsl:apply-templates select="$element/INFO/TITLE" mode="form-info-line">
        	<xsl:with-param name="type" select="'textarea'"  />
        	<xsl:with-param name="inputValue" select="/RESPONSE/URL/searchText"/>
        	<xsl:with-param name="required" select="true()"  />
		</xsl:apply-templates>        
        <xsl:apply-templates select="$element/INFO/DOCUMENTTYPE" mode="form-info-line">
        </xsl:apply-templates>
        <xsl:apply-templates select="$element/INFO/PATH" mode="form-info-line">
        	<xsl:with-param name="required" select="true()"  />
        </xsl:apply-templates>
        <xsl:apply-templates select="$element/INFO/SUMMARY" mode="form-info-line">
        	<xsl:with-param name="type" select="'textarea'"  />
		</xsl:apply-templates>
       	
       	<xsl:call-template name="form-info-line-submit">
       		<xsl:param name="buttonLabel" select="'Create'"/>
       		<xsl:with-param name="createAndNew" select="true()"/>
       	</xsl:call-template>
    </xsl:template>
	
    <!-- custom : additional js -->
    <xsl:template name="panel-add-js">

    </xsl:template>
</xsl:stylesheet>