<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/lib/documents/Index.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <xsl:param name="server" select="/RESPONSE/RESULTS[@name='server']/*[1]" />
    <xsl:param name="list" select="/RESPONSE/RESULTS[@name='list']" />   
    <xsl:param name="items" select="$list/OFFICITY:LIBITEM[INFO/TRASHED='no']" />
    
    <xsl:param name="container" select="/RESPONSE/RESULTS[@name='container']/*[1]" />   
    
    <!-- IDs -->
    <xsl:param name="quickAddDiskFormID">
        <xsl:text>header-diskform-</xsl:text><xsl:value-of select="$panelID" />
    </xsl:param>

	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-quicksearch">
			<xsl:with-param name="list" select="/RESPONSE/RESULTS[@name='list']"/>
			<xsl:with-param name="module" select="'officity:libitem'" />
			<xsl:with-param name="pagingStyle" select="'pager'"/>
	        <xsl:with-param name="addNew" select="false()" />  
	        <xsl:with-param name="params">
	        </xsl:with-param>
    	</xsl:call-template>
    </xsl:template>
        
	<!-- custom : header -->
	<xsl:template name="panel-header-quicksearch">
		<form onsubmit="return false;" style="width:25%">
			<xsl:call-template name="header-quicksearch-input">
				<xsl:with-param name="ID">
					<xsl:text>quicksearch-text</xsl:text>
				</xsl:with-param>
				<xsl:with-param name="searchText" select="'Quick search...'" />
				<xsl:with-param name="resetID">
					<xsl:text>quicksearch-reset</xsl:text>
				</xsl:with-param>
			</xsl:call-template>
		</form>
		<form id="{$quickAddDiskFormID}" class="quickadd-form" style="width:18%">
			<input type="hidden" value="disk">
				<xsl:attribute name="name">
					<xsl:call-template name="gen-info-input-name">
						<xsl:with-param name="moduleName" select="'officity:libitem'" />
						<xsl:with-param name="fieldName" select="'TYPE'" />
					</xsl:call-template>
				</xsl:attribute>
			</input>
			<!-- will add the new disk to user's favorites -->
			<xsl:if test="/RESPONSE/URL/mode='displayfavs'">
				<input type="hidden" name="dependency" value="officity:contactFavorites" />
				<input type="hidden" name="targetModule" value="contact" />
				<input type="hidden" name="targetID" value="{$userID}" />
			</xsl:if>
			<xsl:call-template name="header-input">
				<xsl:with-param name="name">
					<xsl:call-template name="gen-info-input-name">
						<xsl:with-param name="moduleName" select="'officity:libitem'" />
						<xsl:with-param name="fieldName" select="'TITLE'" />
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="ID">
					<xsl:call-template name="gen-info-input-ID">
						<xsl:with-param name="moduleName" select="'officity:libitem'" />
						<xsl:with-param name="fieldName" select="'TITLE'" />
					</xsl:call-template>
					<xsl:text>-quickadd</xsl:text>
				</xsl:with-param>
				<xsl:with-param name="addText" select="'New disk(s)...'" />
				<xsl:with-param name="imgcssclass" select="'img-disk'" />
			</xsl:call-template>
		</form>
		<form onsubmit="return false;" style="width:25%">
			<xsl:call-template name="header-quicksearch-input">
				<xsl:with-param name="ID">
					<xsl:text>quicksearch-favs</xsl:text>
				</xsl:with-param>
				<xsl:with-param name="searchText" select="'Add favorites...'" />
				<xsl:with-param name="resetID">
					<xsl:text>quicksearch-resetfavs</xsl:text>
				</xsl:with-param>
				<xsl:with-param name="resetTitle" select="'Reset favorites search'" />
			</xsl:call-template>
		</form>

		<!-- see include.xsl -->
		<xsl:call-template name="form-actions">
			<xsl:with-param name="container" select="$container"/>
			<xsl:with-param name="createScript">
				<xsl:apply-templates select="$server" mode="element-script-create" /> 
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<!-- custom : quicksearch body -->
	<xsl:template name="panel-body-quicksearch">
        <xsl:param name="list" />
        <xsl:param name="module" />
        <xsl:param name="addNew" />
        <xsl:param name="addNewScript" />
        <xsl:param name="pagingStyle" />
        
		<xsl:call-template name="panel-list-quicksearch">
			<xsl:with-param name="list" select="$list" />
		</xsl:call-template>	
	</xsl:template>
	
	<!-- custom : list -->
	<xsl:template name="panel-list-quicksearch">  
		<xsl:param name="list" />
				
		<xsl:choose>  
			<xsl:when test="$items">			
				<xsl:choose>
					<xsl:when test="/RESPONSE/URL/mode='searchitems'">
				        <xsl:call-template name="list-pager">
				            <xsl:with-param name="list" select="$list"/>
				            <xsl:with-param name="event" select="'loadpage'"/>
				        </xsl:call-template>
				        
						<xsl:for-each select="$items">
							<xsl:sort select="INFO/TYPE='page'" />
							<xsl:sort select="INFO/TYPE='chapter'" />
							<xsl:sort select="INFO/TYPE='book'" />
							<xsl:sort select="INFO/TYPE='file'" />
							<xsl:sort select="INFO/TYPE='folder'" />
							<xsl:sort select="INFO/TYPE='disk'" />
							<xsl:sort select="INFO/KIND" />
							<xsl:sort select="INFO/TITLE" />
							<xsl:apply-templates select="." mode="element-navitem" />
						</xsl:for-each>
						
				        <xsl:call-template name="list-pager">
				            <xsl:with-param name="list" select="$list"/>
				            <xsl:with-param name="event" select="'loadpage'"/>
				        </xsl:call-template>
					</xsl:when>
					<xsl:when test="/RESPONSE/URL/mode='searchfavs'">
				        <xsl:call-template name="list-pager">
				            <xsl:with-param name="list" select="$list"/>
				            <xsl:with-param name="event" select="'loadfavspage'"/>
				        </xsl:call-template>
				        
						<xsl:for-each select="$items">
							<xsl:sort select="INFO/TYPE='page'" />
							<xsl:sort select="INFO/TYPE='chapter'" />
							<xsl:sort select="INFO/TYPE='book'" />
							<xsl:sort select="INFO/TYPE='file'" />
							<xsl:sort select="INFO/TYPE='folder'" />
							<xsl:sort select="INFO/TYPE='disk'" />
							<xsl:sort select="INFO/KIND" />
							<xsl:sort select="INFO/TITLE" />
							<xsl:apply-templates select="." mode="element-navitem-link" />
						</xsl:for-each>
						
				        <xsl:call-template name="list-pager">
				            <xsl:with-param name="list" select="$list"/>
				            <xsl:with-param name="event" select="'loadfavspage'"/>
				        </xsl:call-template>
					</xsl:when>
					<xsl:when test="/RESPONSE/URL/mode='displaydisks'">
						<xsl:call-template name="choose-draggable-navigation">
							<xsl:with-param name="items" select="$items" />		
							<xsl:with-param name="container" select="$container" />					
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="/RESPONSE/URL/mode='displayfavs'">
						<div id="drag-container-{$panelID}">
							<xsl:choose>
								<xsl:when test="count($items)&gt;1">
									<xsl:for-each select="$items">
										<xsl:apply-templates select="." mode="element-navitem-favs-draggable" />
									</xsl:for-each>
									<script type="text/javascript">
										<xsl:call-template name="init-draggable-js">
											<xsl:with-param name="container" select="$container" />
											<xsl:with-param name="dependency" select="/RESPONSE/RESULTS[@name='list']/@type" />
											<xsl:with-param name="itemsCount" select="count($items)" />
										</xsl:call-template>
									</script>
								</xsl:when>
								<xsl:otherwise>
									<xsl:for-each select="$items">
										<xsl:apply-templates select="." mode="element-navitem-favs" />
									</xsl:for-each>
								</xsl:otherwise>
							</xsl:choose>
						</div>
				        <xsl:call-template name="navigationitem">
				        	<xsl:with-param name="id">
				        		<xsl:text>alldisks-</xsl:text>
				        		<xsl:value-of select="$panelID" />
				        	</xsl:with-param>
				            <xsl:with-param name="title">All disks</xsl:with-param>
				            <xsl:with-param name="panelURI">documents/VirtualServerContent</xsl:with-param>
				            <xsl:with-param name="icon">
				            	<xsl:text>../system/images/icons/libitems/server.png</xsl:text>
			            	</xsl:with-param> 
			            	<xsl:with-param name="params">
			            		<xsl:text>serverID:'</xsl:text>
			            		<xsl:value-of select="$server/@ID" />
			            		<xsl:text>'</xsl:text>
			            	</xsl:with-param>
        				</xsl:call-template>
       				</xsl:when>
       				<xsl:otherwise>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<div class="no-result">No hits</div>
			</xsl:otherwise>
		</xsl:choose>

        <!-- <xsl:call-template name="navigationitem">
            <xsl:with-param name="title">Recent history</xsl:with-param>
            <xsl:with-param name="panelURI">documents/RecentsList</xsl:with-param>
            <xsl:with-param name="icon">	            	
       			<xsl:text>../system/images/icons/libitems/folder-app-16.png</xsl:text>
           	</xsl:with-param> 
            <xsl:with-param name="info"></xsl:with-param>
        </xsl:call-template> -->

        <xsl:call-template name="nav-search">
            <xsl:with-param name="title">Advanced search</xsl:with-param>
            <xsl:with-param name="module" select="'officity:libitem'"/>
            <xsl:with-param name="callbackPanel">documents/Search</xsl:with-param>
        </xsl:call-template>
        <xsl:call-template name="nav-savedfilters">
            <xsl:with-param name="title">Saved filters</xsl:with-param>
            <xsl:with-param name="module" select="'officity:libitem'"/>
            <xsl:with-param name="callbackPanel">documents/Search</xsl:with-param>
        </xsl:call-template>
        
        <xsl:call-template name="nav-search">
            <xsl:with-param name="title">Versions search</xsl:with-param>
            <xsl:with-param name="module" select="'officity:libversion'"/>
        </xsl:call-template>
        
        <xsl:call-template name="navigationitem">
        	<xsl:with-param name="id">
        		<xsl:text>trashed-</xsl:text>
        		<xsl:value-of select="$panelID" />
        	</xsl:with-param>
            <xsl:with-param name="title">Trash</xsl:with-param>
	            <xsl:with-param name="panelURI">documents/Trash</xsl:with-param>
	            <xsl:with-param name="icon">
	            	<xsl:choose>
	            		<xsl:when test="/RESPONSE/RESULTS[@name='trashedItemsCount']/@totalCount>0">
	            			<xsl:text>../system/images/icons/libitems/trash-full.png</xsl:text>
	            		</xsl:when>
	            		<xsl:otherwise>
            				<xsl:text>../system/images/icons/libitems/trash-empty.png</xsl:text>
	            		</xsl:otherwise>
	            	</xsl:choose>
            	</xsl:with-param> 
            <xsl:with-param name="info">
            	<xsl:value-of select="/RESPONSE/RESULTS[@name='trashedItemsCount']/@totalCount" />
            	<xsl:text> hit(s)</xsl:text>
           	</xsl:with-param>
        </xsl:call-template>
        
        <!--xsl:call-template name="navigationitem">
            <xsl:with-param name="title">Notifications</xsl:with-param>
            <xsl:with-param name="panelURI">DocNotification/Index</xsl:with-param>
            <xsl:with-param name="icon">	            	
       			<xsl:text>../system/images/icons/notifications/enveloppe-16.png</xsl:text>
           	</xsl:with-param> 
            <xsl:with-param name="info">
           	</xsl:with-param>
        </xsl:call-template-->
	</xsl:template>
	
	<!-- overrides items navigation -->
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='disk' or INFO/TYPE='folder' or INFO/TYPE='book']" mode="element-script-detail">
		<xsl:apply-templates select="." mode="element-script-content"/>
	</xsl:template>
	
	<!-- favorites navigation items -->
	<xsl:template match="OFFICITY:LIBITEM" mode="element-navitem-favs-draggable">
        <xsl:variable name="module">
    		<xsl:call-template name="translate-namespace-name">
        		<xsl:with-param name="name" select="name(.)"/>
        	</xsl:call-template>
        </xsl:variable>
        
		<xsl:call-template name="navigationitem-draggable">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
			<xsl:with-param name="id">
                <xsl:value-of select="$module" />
                <xsl:text>-</xsl:text>
                <xsl:value-of select="@ID" />
            </xsl:with-param>
			<xsl:with-param name="title">
				<xsl:apply-templates select="." mode="element-label"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="." mode="element-script-detail"/>
			</xsl:with-param>
			<xsl:with-param name="params">
               <xsl:apply-templates select="." mode="element-navitem-parms"/>
            </xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon"/>
			</xsl:with-param>
			<xsl:with-param name="info">
				<xsl:apply-templates select="." mode="element-info"/>
			</xsl:with-param>
			<xsl:with-param name="rightactions-elems">
	            <a href="#" class="unlink-action" hover-title="Unlink" title="Remove from favorites">
	                <xsl:attribute name="onclick">
	                    <xsl:call-template name="triggerpanelevent">
	                        <xsl:with-param name="event" select="'updatedependency'"/>
	                        <xsl:with-param name="params">
				                <xsl:text>this, </xsl:text>
				                <xsl:value-of select="@ID" />
				                <xsl:text>, '</xsl:text>
				                <xsl:apply-templates select="." mode="element-script-unlink" />
				                <xsl:text>'</xsl:text>
	                        </xsl:with-param>
	                    </xsl:call-template>
	                </xsl:attribute>
	            </a>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="OFFICITY:LIBITEM" mode="element-navitem-favs">
        <xsl:variable name="module">
    		<xsl:call-template name="translate-namespace-name">
        		<xsl:with-param name="name" select="name(.)"/>
        	</xsl:call-template>
        </xsl:variable>
        
		<xsl:call-template name="navigationitem-actions">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
			<xsl:with-param name="id">
                <xsl:value-of select="$module" />
                <xsl:text>-</xsl:text>
                <xsl:value-of select="@ID" />
            </xsl:with-param>
			<xsl:with-param name="title">
				<xsl:apply-templates select="." mode="element-label"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="." mode="element-script-detail"/>
			</xsl:with-param>
			<xsl:with-param name="params">
               <xsl:apply-templates select="." mode="element-navitem-parms"/>
            </xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon"/>
			</xsl:with-param>
			<xsl:with-param name="info">
				<xsl:apply-templates select="." mode="element-info"/>
			</xsl:with-param>
			<xsl:with-param name="rightactions-elems">
	            <a href="#" class="unlink-action" hover-title="Unlink" title="Remove from favorites">
	                <xsl:attribute name="onclick">
	                    <xsl:call-template name="triggerpanelevent">
	                        <xsl:with-param name="event" select="'updatedependency'"/>
	                        <xsl:with-param name="params">
				                <xsl:text>this, </xsl:text>
				                <xsl:value-of select="@ID" />
				                <xsl:text>, '</xsl:text>
				                <xsl:apply-templates select="." mode="element-script-unlink" />
				                <xsl:text>'</xsl:text>
	                        </xsl:with-param>
	                    </xsl:call-template>
	                </xsl:attribute>
	            </a>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<!-- link navigation item : NOT in dependency -->
    <xsl:template match="OFFICITY:LIBITEM[not(/RESPONSE/RESULTS[@name='depsList']/*/@ID=@ID)]" mode="element-navitem-link">
        <xsl:call-template name="navigationitem-actions">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
            <xsl:with-param name="id">
                <xsl:apply-templates select="." mode="element-navitem-id"/>
            </xsl:with-param>
            <xsl:with-param name="title">
                <xsl:apply-templates select="." mode="element-label"/>
            </xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon"/>
			</xsl:with-param>
            <xsl:with-param name="panelURI">
                <xsl:apply-templates select="." mode="element-script-detail"/>
            </xsl:with-param>
			<xsl:with-param name="params">
               <xsl:apply-templates select="." mode="element-navitem-parms"/>
            </xsl:with-param>
            <xsl:with-param name="info">
                <xsl:apply-templates select="." mode="element-info"/>
            </xsl:with-param>
            <xsl:with-param name="cssclass"/>
			<xsl:with-param name="rightactions-elems">
	            <a href="#" class="link-action" hover-title="Link" title="Add to favorites">
	                <xsl:attribute name="onclick">
	                    <xsl:call-template name="triggerpanelevent">
	                        <xsl:with-param name="event" select="'updatedependency'"/>
	                        <xsl:with-param name="params">
				                <xsl:text>this, </xsl:text>
				                <xsl:value-of select="@ID" />
				                <xsl:text>, '</xsl:text>
				                <xsl:apply-templates select="." mode="element-script-link" />
				                <xsl:text>'</xsl:text>
	                        </xsl:with-param>
	                    </xsl:call-template>
	                </xsl:attribute>
	            </a>
			</xsl:with-param>
        </xsl:call-template>
    </xsl:template>

	<!-- link navigation item : IN dependency -->
    <xsl:template match="OFFICITY:LIBITEM[/RESPONSE/RESULTS[@name='depsList']/*/@ID=@ID]" mode="element-navitem-link">
        <xsl:call-template name="navigationitem-actions">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
            <xsl:with-param name="id">
                <xsl:apply-templates select="." mode="element-navitem-id"/>
            </xsl:with-param>
            <xsl:with-param name="title">
                <xsl:apply-templates select="." mode="element-label"/>
            </xsl:with-param>
            <xsl:with-param name="icon">
                <xsl:apply-templates select="." mode="element-icon"/>
            </xsl:with-param>
            <xsl:with-param name="panelURI">
                <xsl:apply-templates select="." mode="element-script-detail"/>
            </xsl:with-param>
			<xsl:with-param name="params">
               <xsl:apply-templates select="." mode="element-navitem-parms"/>
            </xsl:with-param>
            <xsl:with-param name="info">
                <xsl:apply-templates select="." mode="element-info"/>
            </xsl:with-param>
            <xsl:with-param name="cssclass"/>
			<xsl:with-param name="rightactions-elems">
	            <a href="#" class="unlink-action" hover-title="Unlink" title="Remove from favorites">
	                <xsl:attribute name="onclick">
	                    <xsl:call-template name="triggerpanelevent">
	                        <xsl:with-param name="event" select="'updatedependency'"/>
	                        <xsl:with-param name="params">
				                <xsl:text>this, </xsl:text>
				                <xsl:value-of select="@ID" />
				                <xsl:text>, '</xsl:text>
				                <xsl:apply-templates select="." mode="element-script-unlink" />
				                <xsl:text>'</xsl:text>
	                        </xsl:with-param>
	                    </xsl:call-template>
	                </xsl:attribute>
	            </a>
			</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
	
	<!-- custom : quicksearch js -->
	<xsl:template name="panel-js-quicksearch">
		<xsl:param name="module" />
		<xsl:param name="params" />
		<xsl:param name="panelcssclass" />
		
		$('#<xsl:value-of select="$panelID"/>.panel').addClass('panel-lib-index');
				
	     var quickSearcher<xsl:value-of select="$panelID"/> = new QuickSearcher(
	         <xsl:value-of select="$panelID"/>,
	         AppController,
	         '../../<xsl:value-of select="/RESPONSE/URL/editor"/>/<xsl:value-of select="/RESPONSE/URL/app"/>/<xsl:value-of select="/RESPONSE/URL/panelURI"/>.php',
	         'quicksearch-text',
	         'quicksearch-reset'
	     );
	
	     quickSearcher<xsl:value-of select="$panelID"/>.setDefaultParms({
	         panelID : <xsl:value-of select="$panelID"/>,
	         app : '<xsl:value-of select="/RESPONSE/URL/app" />',
	         editor : '<xsl:value-of select="/RESPONSE/URL/editor" />',
	         module : '<xsl:value-of select="$module"/>'
             <xsl:if test="$params">
             	<xsl:text>,</xsl:text>
             	<xsl:value-of select="$params" />
             </xsl:if>
	     });
	     
	     $('#<xsl:value-of select="$panelID"/>.panel').bind('loadpage', function(eventObject, page){
	         quickSearcher<xsl:value-of select="$panelID"/>.loadPage(page);
	         return false;
	     });
	     
	     // set default refresh callback
	     $('#<xsl:value-of select="$panelID"/>.panel').panel({ 
	     	onRefresh: function(panelElem){
	     		panelElem.trigger('panel-header-reset');
	     		quickSearcher<xsl:value-of select="$panelID"/>.refresh();
	     	}
	     });
	     
	     var quickFavsSearcher<xsl:value-of select="$panelID"/> = new QuickSearcher(
	         <xsl:value-of select="$panelID"/>,
	         AppController,
	         '../../<xsl:value-of select="/RESPONSE/URL/editor"/>/<xsl:value-of select="/RESPONSE/URL/app"/>/<xsl:value-of select="/RESPONSE/URL/panelURI"/>.php',
	         'quicksearch-favs',
	         'quicksearch-resetfavs'
	     );
	
	     quickFavsSearcher<xsl:value-of select="$panelID"/>.setDefaultParms({
	         panelID : <xsl:value-of select="$panelID"/>,
	         app : '<xsl:value-of select="/RESPONSE/URL/app" />',
	         editor : '<xsl:value-of select="/RESPONSE/URL/editor" />',
	         module : '<xsl:value-of select="$module"/>'
             <xsl:if test="$params">
             	<xsl:text>,</xsl:text>
             	<xsl:value-of select="$params" />
             </xsl:if>
	     });
	     
	     $('#<xsl:value-of select="$panelID"/>.panel').bind('loadfavspage', function(eventObject, page){
	         quickFavsSearcher<xsl:value-of select="$panelID"/>.loadPage(page);
	         return false;
	     });
	     
	     quickSearcher<xsl:value-of select="$panelID"/>.onReset(delegate(this, function(){
	     	quickFavsSearcher<xsl:value-of select="$panelID"/>.reset(false);
	     })).onFocus(delegate(this, function(){
	     	quickFavsSearcher<xsl:value-of select="$panelID"/>.reset(false);
	     }));
	     
	     quickFavsSearcher<xsl:value-of select="$panelID"/>.onReset(delegate(this, function(){
	     	quickSearcher<xsl:value-of select="$panelID"/>.reset(false);
	     })).onFocus(delegate(this, function(){
	     	quickSearcher<xsl:value-of select="$panelID"/>.reset(false);
	     }));
	</xsl:template>
	
	<!-- custom : additional js -->
	<xsl:template name="panel-add-js">
		<!-- see include.xsl -->
		<xsl:call-template name="init-panel-header-actions-js" />
	
		<!-- quick add disk -->
		<xsl:call-template name="init-panel-header-quickadd-js">
			<xsl:with-param name="formID" select="$quickAddDiskFormID" /> 
			<xsl:with-param name="container" select="$server" />
			<xsl:with-param name="processingMsg" select="'Adding new disk(s)...'" /> 
		</xsl:call-template>
		
		<!-- add/remove favorites from dependency -->
     	<xsl:call-template name="panel-bind-dependency-event">	
			<xsl:with-param name="dependency" select="'officity:contactFavorites'" />
			<xsl:with-param name="targetModule" select="'contact'" />
			<xsl:with-param name="targetID" select="$userID" />
		</xsl:call-template>
	</xsl:template>
</xsl:stylesheet>