<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/lib/documents/VirtualServerContent.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
        
    <xsl:param name="server" select="/RESPONSE/RESULTS[@name='server']/*[1]" />
    <xsl:param name="list" select="/RESPONSE/RESULTS[@name='list']" />
     <xsl:param name="items" select="$list/OFFICITY:LIBITEM[INFO/TRASHED='no']" />

	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-results">
			<xsl:with-param name="list" select="/RESPONSE/RESULTS[@name='list']"/>
			<xsl:with-param name="module" select="'officity:libitem'" />
			<xsl:with-param name="pagingStyle" select="''"/>
	        <xsl:with-param name="addNew" select="false()" />  
	        <xsl:with-param name="params">
	        </xsl:with-param>
    	</xsl:call-template>
    </xsl:template>

	<!-- overrides draggable items navigation -->
	<xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='disk']" mode="element-script-detail">
		<xsl:apply-templates select="." mode="element-script-content"/>
	</xsl:template>
	
	<!-- results list -->
	<xsl:template name="panel-list-results">
		<xsl:param name="list" />
        <xsl:choose>
            <xsl:when test="$list/OFFICITY:LIBITEM[INFO/TRASHED='no']">
				<xsl:call-template name="choose-draggable-navigation">
					<xsl:with-param name="items" select="$items" />
					<xsl:with-param name="container" select="$server" />
				</xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <div class="no-result">
                	<xsl:text>No hits</xsl:text>
                    <xsl:if test="/RESPONSE/MESSAGE[@msgType!='0']">
                		<br />
                		<span style="font-size:0.6em;">
                			<xsl:text>Warning: </xsl:text>
                			<xsl:value-of select="/RESPONSE/MESSAGE[@msgType!='0']" />
               			</span>
                	</xsl:if>
                </div>
            </xsl:otherwise>
        </xsl:choose>
	</xsl:template>
</xsl:stylesheet>