<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/shared/bug/bug-processors.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	
	/* *** */
	
	class Officity_BugProcessor
	{
		// POST-CREATE
		function sendNewEmail($data)
		{
			$shell = new Sushee_Shell(false);
			$shell->addCommand('
				<GET>
					<OFFICITY:BUG ID="'.$data->getID().'"/>
					<RETURN>
						<INFO creator-info="true"></INFO>
					</RETURN>
				</GET>
			');
			$shell->execute();
			
			$bug = $shell->getElement('/RESPONSE/RESULTS/OFFICITY:BUG');
			if ($bug)
			{
				$creator = $shell->getElement('/RESPONSE/RESULTS/OFFICITY:BUG/INFO/CONTACT');
				if ($creator)
				{
					$email = $creator->valueOf('INFO/EMAIL1');
					$subject = 'New bug (#'.$data->getID().')';
					
					$intro = 'A new bug has been reported:';
					$techno = strtoupper($bug->valueOf('INFO/TECHNOLOGY'));
					$title = $bug->valueOf('INFO/OBJECT');
					$description = $bug->valueOf('INFO/DESCRIPTION');
					$url = 'URL: https://www.officity.com/apps/officity/bugs/?panelURI=BugDetails&ID='.$data->getID().'&module=OFFICITY:BUG&editor=officity&app=bugs&title=Bug%20details';
								
					$body = encode_to_xml($intro.PHP_EOL.PHP_EOL.$techno.': '.$title.PHP_EOL.$description.PHP_EOL.PHP_EOL.$url);
					
					$shell->addCommand('
						<CREATE>
							<SERVERMAIL>
								<RECIPIENT>feedback@nectil.com</RECIPIENT>
								<SUBJECT>'.$subject.'</SUBJECT>
								<BODY>'.$body.'</BODY>
							</SERVERMAIL>
						</CREATE>
					');
					$shell->execute();
				}
			}
		}
		
		// PRE-UPDATE
		function sendStatusEmail($data)
		{
			$new_status = $data->getValue('Status');
			if ($new_status !== $data->getFormerValue('Status'))
			{
				$shell = new Sushee_Shell(false);
				$shell->addCommand('
					<GET>
						<CONTACT ID="'.$data->getValue('CreatorID').'"/>
						<RETURN>
							<INFO><EMAIL1/></INFO>
						</RETURN>
					</GET>
				');
				$shell->execute();
				
				$creator = $shell->getElement('/RESPONSE/RESULTS/CONTACT');
				if ($creator)
				{
					if ($new_status == 'fixed')
					{
						$email = $creator->valueOf('INFO/EMAIL1');
						$subject = 'The bug #'.$data->getID().' has been fixed!';
						$intro = 'The bug #'.$data->getID().' has been fixed.'.PHP_EOL.
									'Please verify that the problem has correctly been solved and close the bug report. You may also check the follow-ups for more information.'.PHP_EOL.
									'Thanks for your support!'.PHP_EOL;
					}
					else if ($new_status == 'verified')
					{
						$email = 'feedback@nectil.com';
						$subject = 'The bug #'.$data->getID().' has been fixed and verified!';
						$intro = 'The bug #'.$data->getID().' has been fixed and verified!'.PHP_EOL;
					}
					else
					{
						if ($data->getFormerValue('Status') == 'fixed')
						{
							$email = 'feedback@nectil.com';
							$subject = 'The bug #'.$data->getID().' fix was rejected, status has changed to "'.$new_status.'"';	
							$intro = 'The bug #'.$data->getID().' fix was rejected, status has changed to "'.$new_status.'". '.
										'Please check the follow-ups on this bug for more information.'.PHP_EOL;
						}
						else
						{
							$email = $creator->valueOf('INFO/EMAIL1');
							$subject = 'The bug #'.$data->getID().' status has changed to "'.$new_status.'"';	
							$intro = 'The bug #'.$data->getID().' status has changed to "'.$new_status.'". '.
										'Please check the follow-ups on this bug for more information.'.PHP_EOL;
						}
					}
					
					$intro .= PHP_EOL.'URL: https://www.officity.com/apps/officity/bugs/?panelURI=BugDetails&ID='.$data->getID().'&module=OFFICITY:BUG&editor=officity&app=bugs&title=Bug%20details'.PHP_EOL.
								PHP_EOL.'*** *** ***'.PHP_EOL.PHP_EOL;

					$techno = strtoupper($data->getValue('Technology'));
					$title = $data->getValue('Object');
					$description = $data->getValue('Description');
					
					$body = encode_to_xml($intro.$techno.': '.$title.PHP_EOL.$description);
					
					$shell->addCommand('
						<CREATE>
							<SERVERMAIL>
								<RECIPIENT>'.$email.'</RECIPIENT>
								<SUBJECT>'.$subject.'</SUBJECT>
								<BODY>'.$body.'</BODY>
							</SERVERMAIL>
						</CREATE>
					');
					$shell->execute();
				}
			}
		}
	}
?>