<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/shared/context/context.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<!-- EDITOR/APPLICATION -->
	<xsl:template match="OFFICITY:CONTEXT" mode="element-editor">
		<xsl:text>officity</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:CONTEXT" mode="element-application">
		<xsl:text>tasks</xsl:text>
	</xsl:template>
	<xsl:template match="OFFICITY:CONTEXT" mode="element-application-editor">
		<xsl:text>officity</xsl:text>
	</xsl:template>
	
	<!-- LABEL(s) -->
	<xsl:template match="OFFICITY:CONTEXT" mode="element-label">
		<xsl:if test="INFO/TITLE/text()">
			<xsl:text>@</xsl:text>
			<xsl:apply-templates select="INFO/TITLE" mode="display-value"/>
		</xsl:if>
	</xsl:template>

	<!-- ICON(s) -->
	<xsl:template match="OFFICITY:CONTEXT" mode="element-icon">
        <xsl:text>../system/images/icons/tasks/context.png</xsl:text>
	</xsl:template>
	
	<xsl:template match="OFFICITY:CONTEXT" mode="element-icon-info">
        <xsl:text>../system/images/icons/tasks/info.png</xsl:text>
	</xsl:template>

	<!-- INFO LABEL(s) -->
	<xsl:template match="OFFICITY:CONTEXT" mode="element-info">
	</xsl:template>
	
    <!-- NAVIGATION ITEM(s) -->
	<xsl:template match="OFFICITY:CONTEXT" mode="element-navitem">
        <xsl:variable name="module">
    		<xsl:call-template name="translate-namespace-name">
        		<xsl:with-param name="name" select="name(.)"/>
        	</xsl:call-template>
        </xsl:variable>

		<xsl:call-template name="navigationitem">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
			<xsl:with-param name="id">
                <xsl:value-of select="$module" />
                <xsl:text>-</xsl:text>
                <xsl:value-of select="@ID"/>
            </xsl:with-param>
			<xsl:with-param name="title">
				<xsl:apply-templates select="." mode="element-label"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:text>ContextsList</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="params">
				<xsl:text>contextID:</xsl:text>
				<xsl:value-of select="@ID"/>
				<xsl:text>,module:'</xsl:text>
				<xsl:value-of select="name(.)" />
				<xsl:text>'</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon"/>
			</xsl:with-param>
			<xsl:with-param name="info">
				<xsl:apply-templates select="." mode="element-info"/>
			</xsl:with-param>
			<xsl:with-param name="cssclass">
				<xsl:if test="count(DEPENDENCIES/DEPENDENCY//OFFICITY:TASK[INFO/STATUS!='finished'])=0">
					<xsl:text>no-children</xsl:text>
				</xsl:if>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
    <xsl:template match="OFFICITY:CONTEXT" mode="element-listitem">
        <xsl:variable name="module">
    		<xsl:call-template name="translate-namespace-name">
        		<xsl:with-param name="name" select="name(.)"/>
        	</xsl:call-template>
        </xsl:variable>
        
		<xsl:call-template name="navigationitem">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
			<xsl:with-param name="id">
                <xsl:value-of select="$module" />
                <xsl:text>-</xsl:text>
                <xsl:value-of select="@ID"/>
            </xsl:with-param>
			<xsl:with-param name="title">				
				<xsl:apply-templates select="." mode="element-label"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="." mode="element-script-detail"/>
			</xsl:with-param>
			<xsl:with-param name="params">ID:<xsl:value-of select="@ID"/>,module:'officity:context'</xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon-info"/>
			</xsl:with-param>
			<xsl:with-param name="info">
			    <xsl:for-each select="ancestor::OFFICITY:CONTEXT">				    
				    <xsl:value-of select="INFO/TITLE" />
				    <xsl:if test="position()!=last()">
				    	<xsl:text>/</xsl:text>
				    </xsl:if>
			    </xsl:for-each>
			</xsl:with-param>
			<xsl:with-param name="cssclass" select="'grey-bkgnd'" />
		</xsl:call-template>
	</xsl:template>
	
	<!-- TITLE(s) -->
	
	<!-- SCRIPTS -->
	<xsl:template match="OFFICITY:CONTEXT" mode="element-script-ops">
		<xsl:value-of select="$systemURL" />
		<xsl:text>call-operation.php?editor=officity</xsl:text>
		<xsl:text disable-output-escaping="yes">&amp;module=context</xsl:text>
		<xsl:text disable-output-escaping="yes">&amp;opObject=Officity_ContextElementOperation</xsl:text>
	</xsl:template>
</xsl:stylesheet>
