<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/shared/task/task.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	class Officity_TaskElement extends Element
	{
		function __construct($ID=0)
		{
			parent::__construct('OFFICITY:TASK', $ID);            
		}

		function __destruct()
		{
			parent::__destruct();
		}
		
		public function setDisplayProfile()
		{
			$this->setReturn(array(
		        'INFO/TITLE',
				'INFO/TYPE',
				'INFO/STATUS',
				'INFO/FLAG'
    		));
		}

        /* *** */
		
		public function parse(&$data_array)
		{
			parent::parse($data_array);
			
			// task specifics
			
            $FOLDER_ID = $_POST['folderID']; 
            if (!empty($FOLDER_ID))
            {
                $this->setDependencyByName('officity:parenttasks', 'OFFICITY:TASK', $FOLDER_ID, 'normal', 'replace');
            }

            $PROJECT_ID = $_POST['projectID'];
            if (!empty($PROJECT_ID))
            {
                $this->setDependencyByName('officity:parenttasks', 'OFFICITY:TASK', $PROJECT_ID, 'normal', 'replace');
            }

            $CONTEXT_ID = $_POST['contextID'];
            if (!empty($CONTEXT_ID)) 
            {
                $this->setDependencyByName('officity:contexts', 'OFFICITY:CONTEXT', $CONTEXT_ID, 'normal', 'replace');
            }
		}

        public function create($execute=true)
        {
            $this->setInfo('OWNERID', 0); // nobody in charge
            //$this->setInfo('OWNERID', $user->getID()); // in charge by default
            
            if (parent::create($execute) == false)
            {
                return false;
            }
            
            // upload files and update
            $upload_result = $this->uploadFiles(true, $execute);               	
            if ($upload_result == false)
            {
            	$upload_err_msg = $this->getLastError();
            }
            
            return true;
        }
        
		public function update($execute=true)
        {
	        // upload files and no update
            $upload_result = $this->uploadFiles(false, $execute);
            if ($upload_result == false)
            {
            	$upload_err_msg = $this->getLastError();
            }

            if (parent::update($execute) == false)
            {
                return false;
            }

            //return $upload_result;
            return true;
        }

		public function destroy()
		{
			if (($ID = $this->getID()) == 0) return false;

			/* *** */

            $nql = new Officity_Shell();

			// 1st : kill all direct elements in dependencies
			/*$kill_command = '
				<KILL name="kill-element">
					<XXX>
						<WHERE>
							<DEPENDENCY type="yyy" mode="reverse">
								<TARGET ID="'.$ID.'" />
							</DEPENDENCY>
						</WHERE>
					</XXX>
				</KILL>';
			$nql->addCommand($kill_command);*/

            //echo 'error';
            //$nql->xml_out();

			$nql->execute();

			/* *** */

			// 2nd : kill kill
			if ($this->kill() == true)
			{
				return true;
			}

			return false;
		}
	}
?>