<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/shared/wiki/wiki.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	class Officity_WikiElement extends Element
	{
		/**#@+
		 * @author	Julien <julien@nectil.com>
		 * @since	2010-03-09
		 */
		const FOLDER_NAME    = 'officity:wiki';
		const UPLOAD_GENERIC = 'generic-upload';
		const UPLOAD_PICTURE = 'picture-upload';
		const UPLOAD_VIDEO   = 'video-upload';
		/**#@-*/
		
		function __construct($ID=0)
		{
			parent::__construct('OFFICITY:WIKI', $ID);
		}

		function __destruct()
		{
			parent::__destruct();
		}
				
		public function setDisplayProfile()
		{
			$this->setReturn(array(
				'INFO/TYPE',
				'DESCRIPTION/HEADER',
				'DESCRIPTION/TITLE'
			));
			
			$this->setDefaultSort('INFO/TYPE', 'ascending');
		}
		
		/* *** */
		
		public function addFile() // TODO : see Task.class.php for file upload
        {
        	$uploadType = null;
        	if (isset($_FILES[self::UPLOAD_GENERIC])) {
        		$uploadType = self::UPLOAD_GENERIC;
        	} elseif (isset($_FILES[self::UPLOAD_PICTURE])) {
        		$uploadType = self::UPLOAD_PICTURE;
        	} elseif (isset($_FILES[self::UPLOAD_VIDEO])) {
        		$uploadType = self::UPLOAD_VIDEO;
        	} else {
        		//discard
        		return true;
        	}        	

            // uploading photo file and using it in PREVIEW field
            $folderpath = '/' . self::FOLDER_NAME . '/'.$this->getID();
			$folder = new Folder($folderpath);
			if (!$folder->exists())
			{
				if ($folder->create() == false)
                {
                    $this->setLastError('folder creation failed! ('.$folderpath.')');
                    return false;
                }
			}

            $uploader = new FilesUploader();
            $uploader->setTarget($folder);
            $uploader->addFile($_FILES[$uploadType]);

            if ($uploader->execute() == false)
            {
                $file_infos = $folderpath.'/'.$_FILES[$uploadType]['name'];
                $file_infos .= ' / '.$_FILES[$uploadType]['type'];
                $file_infos .= ' / '.$_FILES[$uploadType]['size'].' bytes';
                $this->setLastError('upload failed! ('.$file_infos.')');
                return false;
            }

            $files = $uploader->getFiles();
            /*
            if (is_object($files[0]))
            {
                $this->setInfo('PREVIEW', $files[0]->getPath());
            }
            */

            return true;
        }

        /* *** */

		public function destroy()
		{
			if (($ID = $this->getID()) == 0) return false;

			/* *** */

            $nql = new Officity_Shell();

			// 1st : kill all direct elements in dependencies
			/*$kill_command = '
				<KILL name="kill-element">
					<XXX>
						<WHERE>
							<DEPENDENCY type="yyy" mode="reverse">
								<TARGET ID="'.$ID.'" />
							</DEPENDENCY>
						</WHERE>
					</XXX>
				</KILL>';
			$nql->addCommand($kill_command);*/

            //echo 'error';
            //$nql->xml_out();

			$nql->execute();

			/* *** */

			// 2nd : kill kill
			if ($this->kill() == true)
			{
				return true;
			}

			return false;
		}
	}
?>