<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee/shared/class/AbstractFactoryProcessor.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	class AbstractFactoryProcessor
	{	
		protected function getPublishedEnvironments()
		{
			$nql = new Sushee_Shell(false);
			$nql->addCommand('
				<SEARCH>
					<OFFICITY:ENVIRONMENT>
						<INFO>
							<PUBLISHED operator="=">1</PUBLISHED>
							<TYPE operator="NE">versions</TYPE>
						</INFO>
					</OFFICITY:ENVIRONMENT>
					<RETURN>
						<INFO />
					</RETURN>
				</SEARCH>
			');
			$nql->execute();
			
			return $nql->getElements('/RESPONSE/RESULTS/OFFICITY:ENVIRONMENT');
		}
		
		protected function getDevEnvironment()
		{
			$nql = new Sushee_Shell(false);
			$nql->addCommand('
				<SEARCH>
					<OFFICITY:ENVIRONMENT>
						<INFO>
							<PUBLISHED operator="=">1</PUBLISHED>
							<TYPE operator="=">development</TYPE>
						</INFO>
					</OFFICITY:ENVIRONMENT>
					<RETURN>
						<INFO />
					</RETURN>
				</SEARCH>
			');
			$nql->execute();			
			$dev_env = $nql->getElement('/RESPONSE/RESULTS/OFFICITY:ENVIRONMENT');
			return $dev_env;
		}
		
		protected function getEditor($editor_ID)
		{
			$nql = new Sushee_Shell(false);
			$nql->addCommand('
				<GET>
					<NAMESPACE ID="'.$editor_ID.'" />
					<RETURN>
						<INFO />
					</RETURN>
				</GET>
			');
			$nql->execute();
			
			return $nql->getElement('/RESPONSE/RESULTS/NAMESPACE');
		}
		
		protected function getEditorFolder($editor_ID)
		{
			$nql = new Sushee_Shell(false);
			$nql->addCommand('
				<GET>
					<NAMESPACE ID="'.$editor_ID.'" />
					<RETURN>
						<INFO>
							<NAMESPACE />
						</INFO>
					</RETURN>
				</GET>
			');
			$nql->execute();
			
			$editor_folder_name = $nql->valueOf('/RESPONSE/RESULTS/NAMESPACE/INFO/NAMESPACE');
			return $editor_folder_name;
		}
		
		protected function cleanFolderName(&$folder)
		{
			$clean_folder_name = $folder;
			$clean_folder_name = trim($clean_folder_name, '/');
			$clean_folder_name = removeaccents($clean_folder_name);
			$clean_folder_name = strtolower($clean_folder_name);
			$clean_folder_name = preg_replace('/[^a-z0-9_\-]/', '_', $clean_folder_name);
			if (empty($clean_folder_name))
			{
				return new SusheeProcessorException('Folder '.$folder.' is invalid! Only alphanumeric lower-case chars (a-z, 0-9), underscore (_) or hyphen (-) are authorized.');
			}
			
			$folder = $clean_folder_name;
			return true;
		}
		
		/*protected function getFolderContent($folder_path)
		{			
			$folder = new KernelFolder($folder_path);
			$file_paths = array($folder->getCompletePath()); // include folder path
			while ($file = $folder->getNextFile())
			{
				$name = $file->getName();
				if ($name[0] == '.') continue;
				$file_paths []= $file->getCompletePath();
			}
			return $file_paths;
		}*/
		
		protected function removeSVNFolders($path)
		{
			$output = '';
			
			$tmp_folder = new KernelFolder($path);
			if ($tmp_folder->exists())
			{
				$current_command = 'find '.$path.' -name .svn -exec rm -rf {} \;';
				$exec_result = shell_exec($current_command);
				$output .= PHP_EOL.'SVN only: '.$current_command.PHP_EOL.'Output:'.PHP_EOL.trim($exec_result);
			}
			
			return $output;
		}
		
		protected function shellExec($command_string)
		{	
			//var_dump($command_string);
			$exec_result = shell_exec($command_string);
			$output = PHP_EOL.$command_string.PHP_EOL.'Output:'.PHP_EOL.trim($exec_result);
			return $output;
		}
		
		protected function execServerCommands($commands_string, $resources_paths, $command_type)
		{
			$return_message = '';
						
			if (empty($commands_string)) return $return_message;
			if (empty($resources_paths)) return $return_message;
			
			$output = '';
			$commands_string = decode_from_XML($commands_string);
			
			if ($command_type == 'Rename') /* RENAME */
			{
				$output = $command_type.':';
				
				// remove .svn folders that have been copied from the previous folder
				$output .= $this->removeSVNFolders($resources_paths['new_path']);
								
				// apply all commands using old and new paths
				$commands_string = str_replace('%old_path%', $resources_paths['old_path'], $commands_string);
				$commands_string = str_replace('%new_path%', $resources_paths['new_path'], $commands_string);
				$commands_string = str_replace('%comment%', get_class($this), $commands_string);
				
				$commands = explode(PHP_EOL, $commands_string);
				$commands_count = count($commands);
				
				for ($i=0; $i<$commands_count; $i++) 
				{
					$output .= $this->shellExec($commands[$i]);
				} 
			}
			else /* CREATE/UPDATE/DELETE */
			{
				$output = $command_type.' on '.count($resources_paths).' resource(s):'; 
				
				$commands = explode(PHP_EOL, $commands_string);
				$commands_count = count($commands);
				
				if ($command_type == 'Create')
				{
					// apply commands to all files
					foreach ($resources_paths as $path)
					{
						// remove .svn folders that may have been copied from the system packages
						$output .= $this->removeSVNFolders($path);
						
						for ($i=0; $i<$commands_count; $i++) 
						{
							$command_string = str_replace('%path%', $path, $commands[$i]);
							$command_string = str_replace('%comment%', get_class($this), $command_string);
							$output .= $this->shellExec($command_string);
						}
					}
				}	
				else
				{
					// apply commands to all files
					foreach ($resources_paths as $path)
					{
						for ($i=0; $i<$commands_count; $i++) 
						{
							$command_string = str_replace('%path%', $path, $commands[$i]);
							$command_string = str_replace('%comment%', get_class($this), $command_string);
							$output .= $this->shellExec($command_string);
						}
					}
				}
			}
			
			debug_log('Server commands ('.get_class($this).') - '.$output);
			$return_message .= 'Server commands executed:'.PHP_EOL.$output.PHP_EOL;			
			return $return_message;
		}
	}
?>