<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee/shared/namespace/namespace.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<!-- EDITOR/APPLICATION -->
	<xsl:template match="NAMESPACE" mode="element-editor">
		<xsl:text>sushee</xsl:text>
	</xsl:template>
	<xsl:template match="NAMESPACE" mode="element-application">
		<xsl:text>factory</xsl:text>
	</xsl:template>
	<xsl:template match="NAMESPACE" mode="element-application-editor">
		<xsl:text>officity</xsl:text>
	</xsl:template>
	
    <!-- LABEL(s) -->
	<xsl:template match="NAMESPACE" mode="element-label">
        <xsl:apply-templates select="INFO/EDITOR" mode="display-value"/>
        <xsl:text> (</xsl:text>
        <xsl:value-of select="INFO/NAMESPACE"/>
        <xsl:text>)</xsl:text>
	</xsl:template>
	
	<xsl:template match="NAMESPACE[INFO/REGISTERED=1]" mode="element-label">
        <xsl:apply-templates select="INFO/EDITOR" mode="display-value"/>
        <xsl:text> (</xsl:text>
        <xsl:value-of select="INFO/NAMESPACE"/>
        <xsl:text>)</xsl:text>
	</xsl:template>
	
	<xsl:template match="NAMESPACE[INFO/REGISTERED=0]" mode="element-label">
        <span style="color:#666666;">
	        <xsl:apply-templates select="INFO/EDITOR" mode="display-value"/>
	        <xsl:text> (</xsl:text>
	        <xsl:value-of select="INFO/NAMESPACE"/>
	        <xsl:text>)</xsl:text>
        </span>
	</xsl:template>

	<!-- ICON(s) -->
	<xsl:template match="NAMESPACE[not(INFO/ICON/text())]" mode="element-icon">
		<xsl:text>../system/images/icons/namespace/namespace-16.png</xsl:text>
	</xsl:template>
	
	<xsl:template match="NAMESPACE[INFO/ICON/text()]" mode="element-icon">
		<xsl:text>../</xsl:text>
		<xsl:value-of select="INFO/NAMESPACE" />
		<xsl:text>/</xsl:text>
		<xsl:value-of select="INFO/ICON" />
	</xsl:template>

	<!-- INFO LABEL(s) -->
	<xsl:template match="NAMESPACE" mode="element-info">
        <xsl:value-of select="INFO/URL"/>
	</xsl:template>

	<!-- NAVIGATION ITEM(s) -->
	
	<!-- TITLE(s) -->
	
	<!-- SCRIPTS -->
	<xsl:template match="NAMESPACE" mode="element-script-detail">
		<xsl:text>namespaces/Details</xsl:text>
	</xsl:template>

	<xsl:template match="NAMESPACE" mode="element-script-new">
		<xsl:text>namespaces/New</xsl:text>
	</xsl:template>
</xsl:stylesheet>