<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee/shared/processor/processor.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<!-- EDITOR/APPLICATION -->
	<xsl:template match="MODULE" mode="element-editor">
		<xsl:text>sushee</xsl:text>
	</xsl:template>
	<xsl:template match="MODULE" mode="element-application">
		<xsl:text>factory</xsl:text>
	</xsl:template>
	<xsl:template match="MODULE" mode="element-application-editor">
		<xsl:text>officity</xsl:text>
	</xsl:template>
	
    <!-- LABEL(s) -->
	<xsl:template match="PROCESSOR" mode="element-label">
		<xsl:choose>
			<xsl:when test="INFO/TYPE='preprocessor'">
				<xsl:text>PRE-</xsl:text>
			</xsl:when>
			<xsl:when test="INFO/TYPE='postprocessor'">
				<xsl:text>POST-</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>?-</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
        <xsl:value-of select="INFO/COMMAND" />
        <xsl:if test="not(/RESPONSE/URL/moduleID)">
    	    <xsl:text> </xsl:text>
	        <xsl:value-of select="//MODULE[@ID=current()/INFO/MODULEID]/INFO/DENOMINATION"/>
        </xsl:if>
		<xsl:text> (</xsl:text>
		<xsl:value-of select="INFO/ORDERING" />
		<xsl:text>)</xsl:text>
	</xsl:template>

	<!-- ICON(s) -->
	<xsl:template match="PROCESSOR" mode="element-icon">
		<xsl:text>../system/images/icons/processors/processor-16.png</xsl:text>
	</xsl:template>
	
	<!-- INFO LABEL(s) -->
	<xsl:template match="PROCESSOR" mode="element-info">
		<xsl:value-of select="INFO/CLASSNAME" />
		<xsl:text>-></xsl:text>
		<xsl:value-of select="INFO/METHOD" />
		<xsl:text>()</xsl:text>
	</xsl:template>

	<!-- NAVIGATION ITEM(s) -->
	<xsl:template match="PROCESSOR" mode="element-navitem-parms">
        <xsl:text>ID:</xsl:text>
        <xsl:value-of select="@ID"/>
        <xsl:text>,module:'</xsl:text>
        <xsl:value-of select="name(.)"/>
        <xsl:text>',targetModuleID:'</xsl:text>
        <xsl:value-of select="INFO/MODULEID"/>
        <xsl:text>'</xsl:text>
    </xsl:template>
	
	<!-- TITLE(s) -->
	
	<!-- SCRIPTS -->
	<xsl:template match="PROCESSOR" mode="element-script-detail">
		<xsl:text>modules/ProcessorDetails</xsl:text>
	</xsl:template>

	<xsl:template match="PROCESSOR" mode="element-script-new">
		<xsl:text>modules/ProcessorNew</xsl:text>
	</xsl:template>
</xsl:stylesheet>