<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/class/AbstractOperation.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	require_once(dirname(__FILE__).'/JSONResponse.class.php');
	require_once(dirname(__FILE__).'/OfficityException.class.php');
	
	/* *** */
	
	/*
	 * AbstractOperation Class
	 * 
	 * @since	2010-08-26
	 *
	*/
	
	abstract class AbstractOperation
	{
		protected $output_type, $JSON_response, $XML_response;
		
		function __construct()
		{			
			$this->JSON_response = new JSONResponse();	
			$this->XML_response = ''; // TODO		
		}
		
		function __destruct()
		{
			
		}
		
		final public function execute($method_name, $output_type='json')
		{
			$this->output_type = $output_type; 
			
			$method_name = '_'.$method_name;
			$class_name = get_class($this);
			
			// TODO : handle XML response
			$this->JSON_response->set('class', $class_name);
			$this->JSON_response->set('method', $method_name);

			if (!method_exists($class_name, $method_name))
			{
				throw new OfficityException('Method "'.$class_name.'->'.$method_name.'" not found!');
			}
			
			return $this->_execute($method_name);
		}

		abstract protected function _execute($method_name);
		
		public function abort($output_message)
		{
			// TODO : handle XML response
			throw new OfficityException($output_message,  $this->JSON_response);
		}
		
		// TODO : handle XML response
		public function success($output_message='')
		{	
			$this->JSON_response->outputSuccess($output_message);
		}
		
		// TODO : handle XML response
		public function error($output_message='')
		{	
			$this->JSON_response->outputError($output_message);
		}
		
		// TODO : handle XML response
		public function warning($output_message='')
		{	
			$this->JSON_response->outputWarning($output_message);
		}
		
		// TODO : handle XML response
		public function info($output_message='')
		{	
			$this->JSON_response->outputInfo($output_message);
		}
		
		public function getXMLResponse()
		{
			return $this->XML_response;
		}

		public function getJSONResponse()
		{
			return $this->JSON_response->output(false); // please do not die
		}
		
		protected function fetchURLParam($name, $default_value=null)
		{
	        $value = URLParam::fetch($name, $default_value);
	        $this->JSON_response->set($name, $value);
	        return $value;
		}
		
		protected function setResultData($key, $value)
		{
			$this->JSON_response->set($key, $value);
		}
	}
?>