<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/class/OfficityApplication.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/		
	/* *** */
	
	/*
	 * Application Class
	 * 
	 * @since	2010-12-17
	 *
	*/
	
	class Officity_Application
	{
		protected $DEFAULT_CONFIG = array(
			'appFolder' 			=> '',
			'appName' 				=> '',
			'homeTemplatePath'		=> '',
			'elementID'				=> 0,
			'displayModuleTools'	=> true
		);
			
		protected $shell, $config, $app_element;
		protected $app_path, $home_tpl_path;
		
		function __construct()
		{
			$this->shell = new Officity_Shell(false);
			$this->app_element = new Sushee_AppElement();
		}
		
		function __destruct()
		{
			unset($this->shell);
			unset($this->app_element);
		}
		
		public function setConfig($config)
		{	
			$this->config = array_merge($this->DEFAULT_CONFIG, $config);
									
			if (empty($this->config['homeTemplatePath']))
			{
				$this->app_path = EDITOR_PATH.$this->config['appFolder'].'/';
				$this->home_tpl_path = $this->app_path.'HomePanel.xsl';
			}
			else
			{
				$this->home_tpl_path = $this->config['homeTemplatePath'];
			}
		}
		
		public function addShellCommand($command)
		{
			$this->shell->addCommand($command);
		}
		
		public function loadElement()
		{
			if ($this->config['elementID'] > 0)
			{
				$this->app_element->setID($this->config['elementID']);
				if ($this->app_element->find() == false)
				{
					throw new OfficityException('Cannot retrieve application data (ID='.$this->config['elementID'].')!');
				}
			}
			else
			{
				$this->app_element->setInfo('URL', $this->config['appFolder']);
				if ($this->app_element->find() == false)
				{
					throw new OfficityException('Cannot retrieve application data (folder="'.$this->config['appFolder'].'")!');
				}
			}
		}
		
		public function displayHomePanel()
		{
			if (($this->config['elementID'] == 0) && empty($this->config['appFolder']))
			{
				throw new OfficityException('Cannot retrieve application! Please provide an element ID or an application folder.');
			}
			
			$attr = ($this->config['elementID'] > 0) ? 'ID' : 'URL';
			$val = ($this->config['elementID'] > 0) ? 
						$this->config['elementID'] : 
						$this->config['appFolder'];
			$app_crit = '<APP '.$attr.'="'.$val.'" />';
			
			$this->shell->addCommand('
				<SEARCH name="app">
					'.$app_crit.'
					<RETURN>
						<INFO />
		                <DESCRIPTIONS>
		                	<DESCRIPTION>
		                		<SUMMARY />
		                	</DESCRIPTION>
		                </DESCRIPTIONS>
					</RETURN>
				</SEARCH>
			'); 
			
			if ($this->config['displayModuleTools'] == true)
			{	
			    $this->shell->addCommand('
					<SEARCH name="appModules">
						<MODULE>
							<DEPENDENCIES>
								<DEPENDENCY type="officity:appModules" mode="reverse">
									'.$app_crit.'
								</DEPENDENCY>
							</DEPENDENCIES>
						</MODULE>
						<RETURN>
							<INFO>
								<DENOMINATION />
							</INFO>
			                <DESCRIPTIONS>
			                	<DESCRIPTION>
			                		<HEADER />
			                	</DESCRIPTION>
			                </DESCRIPTIONS>
						</RETURN>
					</SEARCH>
			    ');
			}
			
		    // temporary
		    $this->shell->addCommand('
				<SEARCH name="apps">
					<APP>
						<INFO>
							<URL operator ="NE"></URL>
						</INFO>
					</APP>
					<RETURN depth="2">
						<INFO>
							<DENOMINATION />
							<URL />
							<ICON />
						</INFO>
						<DEPENDENCIES>
							<DEPENDENCY type="officity:appNamespaces">
								<INFO>
									<NAMESPACE />
								</INFO>
							</DEPENDENCY>
						</DEPENDENCIES>
					</RETURN>
				</SEARCH>
		    ');
			
			die($this->shell->transform($this->home_tpl_path));
		}
	}
?>