/**
  * jQuery plugins
  *
  * @author  Marc Mignonsin
  * @version 2010-11-12
  *
  */

/*
(function($) {
	// plugin defaults
	var defaults = {
	};
	
	// private function
	function yyyy()
	{
	};

	// plugin definition
	$.fn.xxxx = function(options) {
		var config = $.extend($.fn.xxxx.defaults, options);
		
		return this.each(function() {
	
		});
	};
})(jQuery);
*/

/* FIREBUG CONSOLE */

(function($) {
	$.fn.log = function() {
		if (window.console && window.console.log) 
		{
			return this.each(function() {
				window.console.log(this);
			});
		}
		else 
		{
			//message = '';
			//alert(message);
			return this;
		};
	};
})(jQuery);

(function($) {
	$.info = function(message) {
		if (window.console && window.console.info) 
		{
			window.console.info(message);
		}
		else 
		{
			//alert(message);
		};
		
		return this;
	};
})(jQuery);

(function($) {
	$.warn = function(message) {
		if (window.console && window.console.warn) 
		{
			window.console.warn(message);
		}
		else 
		{
			//alert(message);
		};
		
		return this;
	};
})(jQuery);

//!!! function error is already defined in jQuery !!!
(function($) {
	$.err = function(message) {
		if (window.console && window.console.error) 
		{
			window.console.error(message);
		}
		else 
		{
			//alert(message);
		};
		
		return this;
	};
})(jQuery);

(function($) {
	$.assert = function(expr) {
		if (window.console && window.console.assert) 
		{
			window.console.assert(expr);
		}
		else 
		{
			//alert(expr);
		};
		
		return this;
	};
})(jQuery);

(function($) {
	$.group = function(expr) {
		if (window.console && window.console.group) 
		{
			window.console.group(expr);
		}
		else 
		{
			//alert(expr);
		};
		
		return this;
	};
})(jQuery);

(function($) {
	$.groupEnd = function(expr) {
		if (window.console && window.console.group) 
		{
			window.console.groupEnd(expr);
		}
		else 
		{
			//alert(expr);
		};
		
		return this;
	};
})(jQuery);

/* UTILS */

(function($) {
	$.fn.reverse = function() {
    	return this.pushStack(this.get().reverse(), arguments);
	};
})(jQuery);

/* FORMS */

(function($) {
	$.fn.reset = function() {
	    return this.each(function() {
	        $(this).is('form') && this.reset();
	    });
	};
})(jQuery);

(function($) {
	// plugin defaults
	var defaults = {
		color: '#bbbbbb',
		focusColor : 'black'
	};
	
	// user config, extends from defaults
	var config = { };
	
	// private methods
	var _resetInput = function(input) {
		$(input).val($(input).attr('default-value'));
		$(input).css('color', $(input).attr('default-color') || config.color);
	};
	
	// public methods
	var methods = {
		init : function(options) {
			config = $.extend(defaults, options);
						
			return this.each(function() {
				$(this).find('input[default-value], textarea[default-value]').each(function(){								
					_resetInput(this);
					
				    $(this).focus(function(){
				        if ($(this).val() == $(this).attr('default-value'))
				        {
				        	$(this).css('color', config.focusColor);
				        	$(this).val('');
				        }
				        return true;
				    });
				    
				    $(this).blur(function(){
				        if ($(this).val() == '')
				        {
				        	_resetInput(this);
				        }
				        return true;
				    }); 
				});
			});
		},
		reset : function() {
			return this.each(function() {
				$(this).find('input[default-value], textarea[default-value]').each(function(){	
					_resetInput(this);
				});
			});
		}
	};

	// plugin definition
	$.fn.placeHolders = function(method) {
	    // method calling logic
	    if (methods[method]) 
	    {
	    	return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
	    } 
	    else if (typeof method === 'object' || !method) 
	    {
	    	return methods.init.apply(this, arguments);
	    } 
	    else 
	    {
	    	$.error('Method ' + method + ' does not exist on jQuery.placeHolder!');
	    }
	};
})(jQuery);

/* OBSOLETE! TO REMOVE... */
(function($) {
	$.fn.defaultInputValue = function(defaultValue, defaultColor) {
		defaultColor = (defaultColor) ? defaultColor : '#bbbbbb';
		
	    return this.each(function() {
		    $(this).css('color', defaultColor);
		    $(this).val(defaultValue);
		
		    $(this).focus(function(){
		        if (this.value == defaultValue)
		        {
		            this.style.color = 'black';
		            this.value = '';
		        }
		        return false;
		    });
		    
		    $(this).blur(function(){
		        if (this.value == '')
		        {
		            this.style.color = defaultColor;
		            this.value = defaultValue;
		        }
		        return false;
		    });    
	    });
	};
})(jQuery);

/* AJAX */

(function($) {
	$.getSafeScript = function(url, onSuccess, onError) {
		return this.ajax({
            type: 'GET',
            url: url,
            dataType: 'script',
            async : false,
            success : onSuccess,
            error : onError
		});
	};
})(jQuery);

/* UI */

(function($) {
	$.initDatepicker = function() {
		return this.datepicker({
	        /*dayNames: ['Dimanche', 'Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi'],
	        dayNamesMin: ['Di', 'Lu', 'Ma', 'Me', 'Je', 'Ve', 'Sa'],
	        dayNamesShort: ['Dim', 'Lun', 'Mar', 'Mer', 'Jeu', 'Ven', 'Sam'],
	        monthNames: ['Janvier','Février','Mars','Avril','Mai','Juin','Juillet','Août','Septembre','Octobre','Novembre','Décembre'],
	        monthNamesShort: ['Jan','Fév','Mar','Avr','Mai','Jun','Jul','Aoû','Sep','Oct','Nov','Déc'],
	        clearText: 'Effacer', clearStatus: '',
	        closeText: 'Fermer', closeStatus: 'Fermer sans modifier',
	        prevText: 'Précédent', prevStatus: 'Voir le mois précédent',
	        nextText: 'Suivant', nextStatus: 'Voir le mois suivant',
	        currentText: 'Courant', currentStatus: 'Voir le mois courant',
	        monthStatus: 'Voir un autre mois', yearStatus: 'Voir un autre année',
	        weekHeader: 'Sm', weekStatus: '',
	        dayStatus: 'Utiliser DD comme premier jour de la semaine', dateStatus: 'Choisir le DD, MM d',
	        initStatus: 'Choisir la date',*/
	        dateFormat: 'dd/mm/yy',
	        buttonImage: '../sharedimages/icons/calendar.png',
	        buttonImageOnly: true,
	        buttonText: 'Choose date',
	        showOn: 'button',
	        firstDay: 1,
	        showOtherMonths: true,
	        isRTL: false,
	        changeYear: true,
	        yearRange: '1900:2100',
	        showAnim: 'fadeIn' 
	    });
	};
})(jQuery);

$.widget("custom.catcomplete", $.ui.autocomplete, {
	_renderMenu: function( ul, items ) {
		var self = this, currentCategory = (items.length > 0) ? items[0].category : '';
		
		$.each(items, function(index, item) {
			if (item.value == undefined) return;
	
			if (item.assignable == 1)
			{
				if (item.category != currentCategory) 
				{	
					ul.append('<li class="ui-autocomplete-category">' + item.category + '</li>');
					currentCategory = item.category;
				}
				
				if (item.isCateg == 1)
				{
					$('<li></li>').data("item.autocomplete", item).append('<a style="font-variant:small-caps; font-weight:bold !important;">'+item.label+'</a>').appendTo(ul);
				}
				else
				{
					self._renderItem(ul, item);
				}
			}
			/*else
			{
				ul.append('<li class="ui-autocomplete-nonassignable">' + item.label + '</li>');
			}*/
		});
	}
});
