<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/packages/application/panels/NavDraggableItems.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
	<!-- parameters -->
    <xsl:param name="list" select="/RESPONSE/RESULTS[@name='list']"/>    
    <xsl:param name="sortFormID">
        <xsl:text>sort-form-</xsl:text>
        <xsl:value-of select="$panelID"/>
    </xsl:param>
    
	<xsl:template match="/RESPONSE">
		<xsl:call-template name="panel-navigation" />
	</xsl:template>
	
	<xsl:template name="panel-body-navigation">
        <xsl:choose>
            <xsl:when test="$list/@hits > 0">   
				<xsl:apply-templates select="$list/*" mode="element-navitem-draggable" />
            </xsl:when>
            <xsl:otherwise>
                <div class="no-result">No hits</div>
            </xsl:otherwise>
        </xsl:choose>
	</xsl:template>

    <xsl:template name="panel-js-navigation">
            <!-- INIT -->
            $('#<xsl:value-of select="$panelID"/>.panel .block-nav').sortable({
	            handle : '.drag-handle',
                containment : '#<xsl:value-of select="$panelID"/>.panel .block-nav',
                start: function(event, ui) { 
                	ui.item.addClass('dragged'); 
               	},
                stop: function(event, ui) { 
	           		ui.item.removeClass('dragged'); 
	           		//$('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [true, 'body']);
	           		
		            var sortedElems = $('#<xsl:value-of select="$panelID"/>.panel .block-nav').sortable('toArray');
	
					// get rid of the prefix in order to send an array of element IDs
					for (var i in sortedElems)
					{
						// e. g. : contact-5
						var idParts = sortedElems[i].split('-', 2); 
						sortedElems[i] = idParts[1];
					}
					
	                var updateRequest = new AjaxRequest(
	                    <xsl:value-of select="$panelID"/>,
	                    AppController,
	                    '<xsl:apply-templates select="$list/*[1]" mode="element-script-sort-deps"/>',
	                    'POST',
	                    'json'
	                );
	
	                updateRequest.setData({sortedIDs:sortedElems});
	                updateRequest.addData('dependency', 'contactWork');
	                updateRequest.addData('targetModule', 'CONTACT');
	                updateRequest.addData('ID', <xsl:value-of select="/RESPONSE/URL/societyID"/>);
	                
					// display error dialog and return errors in long msgs format
					updateRequest.errorDialog(true, false);
					updateRequest.internalErrorDialog(true, false);
	
	                updateRequest.onSuccess(function(response){
	                    //$('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [false, 'body']);
	                }).onError(function(response){
	                    //$('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-displayloader', [false, 'body']);
	                }).send();
             	},
             	revert:25,
             	placeholder:'items draggable dragged-placeholder',
             	forcePlaceholderSize:true
            }).disableSelection();
	</xsl:template>
</xsl:stylesheet>
