<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/system.functions.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	/* SUSHEE ERROR CODES */

	define('SUSHEE_ERRORCODE_NOERROR',				0);
	define('SUSHEE_ERRORCODE_ELEMENTMOD',			1);
	define('SUSHEE_ERRORCODE_EMAILUSED',			2);
	define('SUSHEE_ERRORCODE_CLIENTCODEUSED',		3);
	define('SUSHEE_ERRORCODE_UPDATEONEMPTYELEMSET',	4);

    /* SYSTEM FUNCTIONS */
    
	 function xmlpp($xml) 
	 {    
	 	// add marker linefeeds to aid the pretty-tokeniser (adds a linefeed between all tag-end boundaries)
	 	$xml = preg_replace('/(>)(<)(\/*)/', "$1\n$2$3", $xml);

	 	// now indent the tags
	 	$token      = strtok($xml, PHP_EOL);
	 	$result     = ''; // holds formatted version as it is built
	 	$pad        = 0; // initial indent
	 	$pad_string = '&#160;&#160;&#160;&#160;';
	 	$matches    = array(); // returns from preg_matches()

	 	// scan each line and adjust indent based on opening/closing tags
	 	while ($token !== false)
	 	{
	 		$token = trim($token);
	 		 
	 		// test for the various tag states

	 		// 1. open and closing tags on same line - no change
	 		if (preg_match('/.+<\/\w[^>]*>$/', $token, $matches))
	 		{
	 			$indent=0;
	 		}
	 		else if (preg_match('/^<\/\w/', $token, $matches))
	 		{
	 			// 2. closing tag - outdent now	 			
	 			$pad--;
	 			$indent = 0;
	 		}
	 		else if (preg_match('/^<\w[^>]*[^\/]>.*$/', $token, $matches))
	 		{
	 			// 3. opening tag - don't pad this one, only subsequent tags
	 			$indent=1;
	 		}
	 		else
	 		{
	 			// 4. no indentation needed
	 			$indent = 0;
	 		}

	 		if (!empty($token))
	 		{
		 		// pad the line with the required number of leading spaces
		 		$line = htmlentities($token);
		 		for ($i=0; $i<$pad; $i++) $line = $pad_string.$line;
		 		$result .= '<br />'.$line; // add to the cumulative result, with linefeed
	 		}
	 		$token   = strtok(PHP_EOL); // get the next token
	 		$pad    += $indent; // update the pad size for subsequent lines
	 	}
	 	 
	 	return $result;
	 } 
	 
 	function sizeToHuman($realsize)
	{
		$size = $realsize;
		if ($realsize < 0) // ???
		{
			$size *= -1;
		}

		$size_human = '';
		$kb = 1024;
		$mb = $kb * 1024;
		$gb = $mb * 1024;
		$tb = $gb * 1024;
		if ($size >= $tb) {
			$size_human = round($size / $tb, 2).' Tb';
		} elseif ($size >= $gb) {
			$size_human = round($size / $gb, 2).' Gb';
		} else if ($size >= $mb) {
			$size_human = round($size / $mb, 2).' Mb';				
		} else if ($size >= $kb) {
			$size_human = round($size / $kb, 2).' Kb';	
		} else {
			$size_human = $size.' bytes';
		}

		if ($realsize < 0)
		{
			$size_human = '- '.$size_human;
		}

		return $size_human;
	}
	
    function displayErrorPanel($message, $title='')
    {
        $nql = new Officity_Shell();

        $nql->addCommand('
        	<RESULTS name="errorMessage" static="true">
            	<TITLE>'.$title.'</TITLE>
                <MESSAGE>'.$message.'</MESSAGE>
                <CLASS>critical-error</CLASS>
       		</RESULTS>
       	');
	        
        $error_template_path = SYSTEM_TOOLS_PATH.'/error/Error.xsl';
        if (isset($_GET['editor']))
        {
            $editor_folder = $_GET['editor'];
            $editor_error_template_path = APPS_PATH.$editor_folder.'/shared/error/Error.xsl';
            if (file_exists($editor_error_template_path))
            {
                $error_template_path = $editor_error_template_path;
            }
        }
        
        die($nql->transform($error_template_path));
    }
    
    function display_paths_and_urls()
    {
        if ($_GET['url'] == true)
		{
			var_dump(ROOT_PATH); echo '<br />';
			var_dump(KERNEL_PATH);  echo '<br />';
			var_dump(LIBRARY_PATH);  echo '<br />';
			var_dump(FILES_PATH);  echo '<br />';
			var_dump(APPS_PATH);  echo '<br />';
			var_dump(SYSTEM_PATH);  echo '<br />';
			var_dump(SYSTEM_CLASS_PATH);  echo '<br />';
			var_dump(SYSTEM_TOOLS_PATH);  echo '<br />';
			var_dump(SYSTEM_PACKAGES_PATH);  echo '<br />';
	    	var_dump(EDITOR_PATH);  echo '<br />';
			var_dump(SHARED_PATH); echo '<br />';
				    	    
			var_dump(ROOT_URL);  echo '<br />';	
			var_dump(APPS_URL);  echo '<br />';
			var_dump(SYSTEM_URL);  echo '<br />';
			var_dump(SYSTEM_TOOLS_URL);  echo '<br />';
			var_dump(EDITOR_URL);  echo '<br />';
			var_dump(SHARED_URL); echo '<br />';
	    	var_dump(SHARED_IMAGES_URL); echo '<br />';
		}
    }
    
    function system_logout()
	{
		// --- to not autologin after logout ---
		$expire_time = time() + 60; // 60 minutes
    	setcookie('logout', 'true', $expire_time);
    	
    	// --- logout ---
    	logout();
	}
	
    function outputHTTPError($msg, $status_code=600)
    {
	    header('HTTP/1.1 '.$status_code.' '.$msg);
		header('Status: '.$status_code.' '.$msg);
		die();
    }

    /* UTILS */

	function logXML(&$nql)
    {
        $nql->execute();
        die(htmlentities($nql->getResponse()));
    }

    function logQuery(&$nql)
    {
        die(htmlentities($nql->getQuery()));
    }
    
    function generatePIN($size=8)
    {
        $pin = "";
        $chars = "abcdefghjkmnpqrstuvwxyzABCDEFGHJKMNPQRSTUVWXYZ23456789";
        for ($i=0; $i<$size; $i++)
        {
            $pin .= $chars[rand(0,strlen($chars)-1)];
        }
        return $pin;
    }

	function compute_age($given_date)
	{
		if (empty($given_date))
		{
			return false;
		}

		$age = -1;

		list($given_year, $given_month, $given_day) = split('[-.]', $given_date);

		if ((intval($given_year) == 0) || (intval($given_month) == 0) || (intval($given_day) == 0)) return $age;

		$date = new Date($given_date); // ?
		$today_date = new Date(date('Y-m-d'));

		if ($today_date->isLowerThan($date)) return $age;

		/* *** */

		// TOOD : change => take these values from $today_date...
		$this_year = date('Y');
		$this_month = date('n');
		$this_day = date('j');

		$years = $this_year - $given_year;

		if ($this_month < $given_month)
		{
			$years--;
		}
		else
		{
			if (($this_month == $given_month) && ($this_day < $given_day)) $years--;
		}

		$age = $years;

		if ($age == 0)
		{
			// in months...
			$age = $this_month - $given_month;
			if ($this_day < $given_day) $age--;
			$age = '.'.$age;
		}

		return $age;
	}

	function set_age_attribute(&$nectil_element)
	{
		$birthday = $nectil_element->getElement("INFO/BIRTHDAY");

		$age = compute_age($birthday->valueOf());

		$birthday->setAttribute('age', $age);
	}

	/* VARIABLES, CONSTANTS */

	function empty_const($const_name)
	{
		$const_value = constant($const_name);
		return (($const_value === null) || ($const_value === '') || ($const_value === 0) || ($const_value === '0'));
	}

	function exists(&$var)
	{
		if (isset($var)) return !empty($var);
		return false;
	}

    function empty_date($date)
	{
		return ((empty($date)) || ($date == '0000-00-00'));
	}

	/* DATES */

	// TODO : check for today, this_week, etc. used in search
	function nql_date($date)
	{
		if (empty($date)) return $date; //'????-??-?? (empty date)';

		// already yyyy-mm-dd?
		$nql_regexp = '(19|20)?[0-9][0-9]-(0?[1-9]|1[0-2])-(0?[1-9]|[1-2][0-9]|3[0-1])';
        if (preg_match('/'.$nql_regexp.'/', $date) == 1) return $date; 
        
        // not dd/mm/yyyy?
        $user_regexp = '(0?[1-9]|[1-2][0-9]|3[0-1])\/(0?[1-9]|1[0-2])\/(19|20)?[0-9][0-9]';
		if (preg_match('/'.$user_regexp.'\z/', $date) != 1) return $date;//'????-??-?? (invalid user date format)';

	 	list($dd, $mm, $yyyy) = explode('/', $date);	 	
	 	
	 	if (!@checkdate($mm, $dd, $yyyy)) return '????-??-?? (invalid calendar date)'; 
		
		return sprintf('%04d-%02d-%02d', $yyyy, $mm, $dd);
	}
	
	// TODO : check for today, this_week, etc. used in search
	function nql_datetime($datetime)
	{
		if (empty($datetime)) return $datetime; //'????-??-?? ??:??:?? (empty datetime)';

		// already yyyy-mm-dd hh:mm:ss?
		$nql_regexp = '(19|20)?[0-9][0-9]-(0?[1-9]|1[0-2])-(0?[1-9]|[1-2][0-9]|3[0-1]) ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])';
        if (preg_match('/'.$nql_regexp.'/', $datetime) == 1) return $datetime; 
        
        // not dd/mm/yyyy [hh:mm:ss]?
        $user_regexp = '(0?[1-9]|[1-2][0-9]|3[0-1])\/(0?[1-9]|1[0-2])\/(19|20)?[0-9][0-9]( ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9]))?';
		if (preg_match('/'.$user_regexp.'\z/', $datetime) != 1) return $datetime; //'????-??-?? ??:??:?? (invalid user datetime format)';

        list($date, $time) = explode(' ', $datetime);
        if (empty($time))
        {
            $time = '00:00:00';
        }
        else
        {
        	list($hours, $minutes, $seconds) = explode(':', $time, 3);
        	$time = sprintf('%02d:%02d:%02d', $hours, $minutes, $seconds);
        }
		
        list($dd, $mm, $yyyy) = explode('/', $date);
        
        if (!@checkdate($mm, $dd, $yyyy)) return '????-??-?? ??:??:?? (invalid calendar date)'; 

		return sprintf('%04d-%02d-%02d', $yyyy, $mm, $dd).' '.$time;
	}

	function jjmmaaa_date($date)
	{
		if (empty($date))return;

		list($year, $month, $day) = explode('-', $date, 3);
		return $day.'/'.$month.'/'.$year;
	}

    function jjmmaaa_datetime($datetime)
	{
		if (empty($datetime))return;

        list($date, $time) = explode(' ', $datetime);
		list($year, $month, $day) = explode('-', $date, 3);

        $date = $day.'/'.$month.'/'.$year;

        if (!empty($time))
        {
            list($h, $m, $s) = explode(':', $time, 3);
            $date .= ' @ '.$h.':'.$m.':'.$s;
        }

		return $date;
	}

	function lastDay($month, $year)
	{
		$last_day = date("j", mktime(0,0,0, $month + 1, 0, $year));
		return $last_day;
	}

    function today()
    {
        return date('Y-m-d');
    }

	/* FILES */

	function file_security_checks($file_array)
	{
		if (empty($file_array['name']) == true)
		{
			return false;
		}

		if ($file_array['error'] != 0)
		{
			return false;
		}

		/*if ($file_array['tmp_size'] > ...) // just in case
		{
			return false;
		}*/

		if (@is_uploaded_file($file_array['tmp_name']) == false)
		{
			return false;
		}

		return true;
	}

	function upload_file($uploaded_file_array, $destination_dir, $new_file_prefix='')
	{
		if (!file_exists($destination_dir))
		{
			if (mkdir($destination_dir, 0755) == false)
			{
				debug_log('UPLOAD ERRROR : cannot create "'.$destination_dir.'"!');
				return false;
			}
		}

		//var_dump($uploaded_file_array);

		/* *** */

		$name =  $uploaded_file_array['name'];
		$type =  $uploaded_file_array['type'];
		$tmp_name =  $uploaded_file_array['tmp_name'];
		$error =  $uploaded_file_array['error'];
		$size =  $uploaded_file_array['size'];
		$uploaded_file_array['tmp_size'] = @filesize($tmp_name);

		if (file_security_checks($uploaded_file_array) == false)
		{
			debug_log('UPLOAD ERRROR : file_security_checks failed!');
			return false;
		}

		/* *** */

		$clean_name = strtolower(basename($name));
		$clean_name = preg_replace('/[^a-z0-9\._]/', '_', $clean_name);

		$final_location = $destination_dir.$new_file_prefix.$clean_name;

		$move_result = @move_uploaded_file($tmp_name, $final_location);

		if ($move_result == false)
		{
			debug_log('UPLOAD ERRROR : move to "'.$final_location.'" failed!');
			return false;
		}

		/* *** */

		return $final_location;
	}
	
	function clean_filename($name)
	{
		$clean_name = basename($name);
		$clean_name = removeaccents($clean_name);
		$clean_name = strtolower($clean_name);
		$clean_name = preg_replace('/[^a-z0-9\._]/', '_', $clean_name);
		return $clean_name;
	}
?>
