<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/element/New.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <!-- parameters -->
    <xsl:param name="module" select="/RESPONSE/URL/module"/>
    <xsl:param name="dependency" select="/RESPONSE/URL/dependency"/>
    <xsl:param name="targetModule" select="/RESPONSE/URL/targetModule"/>
    <xsl:param name="targetID" select="/RESPONSE/URL/targetID"/>
    
    <xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]"/>
        
    <xsl:param name="susheeFields" select="$fields[INFO/DENOMINATION='ID' or
				INFO/DENOMINATION='ACTIVITY' or
				INFO/DENOMINATION='ISLOCKED' or
				INFO/DENOMINATION='CREATORID' or
				INFO/DENOMINATION='OWNERID' or
				INFO/DENOMINATION='GROUPID' or
				INFO/DENOMINATION='MODIFIERID' or
				INFO/DENOMINATION='CREATIONDATE' or
				INFO/DENOMINATION='MODIFICATIONDATE' or
				INFO/DENOMINATION='SEARCHTEXT' or
				INFO/DENOMINATION='CREATOR' or
				INFO/DENOMINATION='MODIFIER' or
				INFO/DENOMINATION='OWNER']" />
    
   	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-newelement">
    		<xsl:with-param name="element" select= "$item" />
    		<xsl:with-param name="displaySusheeTab" select="true()"/>
    	</xsl:call-template>
    </xsl:template>
	
	<!-- editor fields -->
    <xsl:template name="element-tab-info">      
    	<xsl:param name="element" /> 
    	 
		<!-- optional : use for creating new elements in dependency -->
		<xsl:if test="$dependency">
			<input type="hidden" id="dependency" name="dependency" value="{$dependency}" />
		</xsl:if>
		<xsl:if test="$targetModule">
			<input type="hidden" id="targetModule" name="targetModule" value="{$targetModule}" />
		</xsl:if>
		<xsl:if test="$targetID">
			<input type="hidden" id="targetID" name="targetID" value="{$targetID}" />
		</xsl:if>
 		
        <xsl:for-each select="$element/INFO/*[not($susheeFields/INFO/DENOMINATION=name())]">
            <xsl:sort select="name()" />
       		<xsl:apply-templates select="." mode="form-info-line" />
        </xsl:for-each>
	    
	    <xsl:apply-templates select="$element" mode="form-info-line-submit">
	    	<xsl:with-param name="buttonLabel" select="'Create'"/>
      		<xsl:with-param name="createAndNew" select="true()" />
	    </xsl:apply-templates>
    </xsl:template>
    
	<!-- sushee fields -->
    <xsl:template name="element-tab-sushee">      
    	<xsl:param name="element" /> 
    	 
		<!-- optional : use for creating new elements in dependency -->
		<xsl:if test="$dependency">
			<input type="hidden" id="dependency" name="dependency" value="{$dependency}" />
		</xsl:if>
		<xsl:if test="$targetModule">
			<input type="hidden" id="targetModule" name="targetModule" value="{$targetModule}" />
		</xsl:if>
		<xsl:if test="$targetID">
			<input type="hidden" id="targetID" name="targetID" value="{$targetID}" />
		</xsl:if>
 		        
        <xsl:for-each select="$element/INFO/*[$susheeFields/INFO/DENOMINATION=name() and
	        	name()!='ID' and name()!='ACTIVITY' and
	        	name()!='CREATORID' and name()!='CREATIONDATE' and  
	        	name() != 'MODIFIERID' and name() != 'MODIFICATIONDATE' and
	        	name()!='CREATOR' and name()!='MODIFIER' and name()!='OWNER']">
            <xsl:sort select="name()" />
       		<xsl:apply-templates select="." mode="form-info-line" />
        </xsl:for-each>
	    
	    <xsl:apply-templates select="$element" mode="form-info-line-submit">
	    	<xsl:with-param name="buttonLabel" select="'Create'"/>
      		<xsl:with-param name="createAndNew" select="true()" />
	    </xsl:apply-templates>
    </xsl:template>
</xsl:stylesheet>