<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/error/Log.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:import href="include.xsl"/>
	<xsl:output encoding="UTF-8" method="xml" indent="no"/>
	<xsl:strip-space elements="*"/>

   	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-log">
    		<xsl:with-param name="logNode" select="/RESPONSE/RESULTS[@name='log']" />
    		<xsl:with-param name="optimalWidth" select="600" />
    		<xsl:with-param name="bodyOnly" select="boolean(URL/page)" /> 
    	</xsl:call-template>
    </xsl:template>
    
    <!-- custom body -->
    <xsl:template name="panel-body-log">
    	<xsl:param name="logNode" />
    
		<div class="block-log">
			<div id="log-msg">
				<h1>
					<xsl:copy-of select="$logNode/TITLE/node()" />
				</h1>
				<xsl:apply-templates select="$logNode/MESSAGE/node()" />
			</div>
           </div>
    </xsl:template>
    
    <xsl:template match="MESSAGE/*[not(/RESPONSE/URL/logXML)]">
    	<p>
    		<xsl:copy-of select="." />
   		</p>
    </xsl:template>
    
    <xsl:template match="MESSAGE/*[/RESPONSE/URL/logXML]">
    	<div style="font-size:1.3em">
    		<xsl:call-template name="actions" />
    		<div>
		   		<xsl:text>&lt;</xsl:text>
		   		<xsl:value-of select="name(.)" />
		   		<xsl:apply-templates select="./@*" mode="build-xml-tree"/>
		   		<xsl:text>&gt;</xsl:text>
		   		<div style="margin-left:11px;">
    				<xsl:apply-templates select="node()" mode="build-xml-tree" />
    			</div>
		   		<xsl:text>&lt;/</xsl:text>
		   		<xsl:value-of select="name(.)" />
		   		<xsl:text>&gt;</xsl:text>
    		</div>
			<xsl:call-template name="actions" />
   		</div>
    </xsl:template>
    
    <xsl:template match="*" mode="build-xml-tree">
		<xsl:variable name="hide-by-default" select="local-name()='URL' or local-name()='NECTIL'"/>
    	<a href="#" class="node collapsable" onclick="$('#{$panelID}.panel').trigger('toggle', [this]);">
		<xsl:if test="$hide-by-default">
			<xsl:attribute name="class">node expandable</xsl:attribute>
		</xsl:if>
		</a>
   		<span class="{local-name()}">
	   		<xsl:text>&lt;</xsl:text>
	   		<xsl:value-of select="name(.)" />
	   		<xsl:apply-templates select="./@*" mode="build-xml-tree"/>
	   		<xsl:text>&gt;</xsl:text>
	   		<div>
				<xsl:attribute name="style">
					<xsl:text>margin-left:11px;</xsl:text>
					<xsl:if test="$hide-by-default">display:none;</xsl:if>
				</xsl:attribute>
	   			<xsl:apply-templates select="./node()" mode="build-xml-tree" />
	   		</div>
	   		<xsl:text>&lt;/</xsl:text>
	   		<xsl:value-of select="name(.)" />
	   		<xsl:text>&gt;</xsl:text>
   		</span>
   		<br />
    </xsl:template>
    
    <xsl:template match="*[text()]" mode="build-xml-tree">
    	<span class="{local-name()}">
   			<xsl:text>&lt;</xsl:text>
	   		<xsl:value-of select="name(.)" />
	   		<xsl:apply-templates select="./@*" mode="build-xml-tree"/>
	   		<xsl:text>&gt;</xsl:text>
			<xsl:apply-templates select="./node()" mode="build-xml-tree" />   		
	   		<xsl:text>&lt;/</xsl:text>
	   		<xsl:value-of select="name(.)" />
	   		<xsl:text>&gt;</xsl:text>
   		</span>
   		<br />
    </xsl:template>
    
    <xsl:template match="*[not(node())]" mode="build-xml-tree">
    	<span class="{local-name()}">
	   		<xsl:text>&lt;</xsl:text>
   			<xsl:value-of select="name(.)" />
   			<xsl:apply-templates select="./@*" mode="build-xml-tree"/>
   			<xsl:text> /&gt;</xsl:text>
  		</span>
   		<br />
    </xsl:template>
    
    <xsl:template match="text()" mode="build-xml-tree">
   		<xsl:value-of select="." />
    </xsl:template>
    
    <xsl:template match="@*" mode="build-xml-tree">
    	<span class="{local-name()}">
	    	<xsl:text> </xsl:text>
	    	<xsl:value-of select="name(.)" />
	    	<xsl:text>="</xsl:text>
	    	<xsl:value-of select="." />
	    	<xsl:text>"</xsl:text>
    	</span>
    </xsl:template>
    
    <xsl:template name="actions">
    	<div style="text-align:left; margin:10px 0;">
			<a href="#" class="expand-collapse-link">
	   			<xsl:attribute name="onclick">
	   				$('#<xsl:value-of select="$panelID" />.panel').trigger('expand');
	   			</xsl:attribute>
	   			<xsl:text>Expand all</xsl:text>
	  		</a>
	  		<xsl:text> | </xsl:text>
	  		<a href="#" class="expand-collapse-link">
	   			<xsl:attribute name="onclick">
	   				$('#<xsl:value-of select="$panelID" />.panel').trigger('collapse');
	   			</xsl:attribute>
	  			<xsl:text>Collapse all</xsl:text>
			</a>
		</div>
    </xsl:template>
    
    <xsl:template name="panel-add-js">
    	$('#<xsl:value-of select="$panelID" />.panel').bind('toggle', function(event, linkElem){
    		$(linkElem).toggleClass('collapsable').toggleClass('expandable').next('span').children('div').toggle();
    	});
    	$('#<xsl:value-of select="$panelID" />.panel').bind('expand', function(){
    		$(this).find('a.expandable').removeClass('expandable').addClass('collapsable').next('span').children('div').show();
    	});
    	$('#<xsl:value-of select="$panelID" />.panel').bind('collapse', function(){
    		$(this).find('a.collapsable').removeClass('collapsable').addClass('expandable').next('span').children('div').hide();
    	});
    </xsl:template>
</xsl:stylesheet>