<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/followup/List.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	include_once(dirname(__FILE__).'/include.php');

	/* *** */
	
	$nql = new Officity_Shell(true); // include navigation.xml for SuperAdmins and SupportTeam contacts list
	
	$user = new OfficityUser();
	$_GET['userName'] = $user->getField('FirstName').' '.$user->getField('LastName');

	$MODULE = $_POST['module'];
	if (empty($MODULE))
	{
		$nql->displayErrorPanel('No module specified!');
	}
	$MODULE = strtoupper($MODULE);

	$ITEM_ID = $_POST['ID'];
	if (empty($ITEM_ID))
	{
		$nql->displayErrorPanel('No element ID!'); 
	}

	/* *** */

    $element = new Element($MODULE);
	$MODULE_ID = $element->getModuleID();
	
	$nql->addCommand(
		'<GET name="item">
			<'.$MODULE.' ID="'.$ITEM_ID.'"/>
			<RETURN>
				<NOTHING/>
			</RETURN>
		</GET>');
		
	$nql->addCommand(
		'<SEARCH name="followups">
			<OFFICITY:FOLLOWUP targetid="'.$ITEM_ID.'" moduletargetid="'.$MODULE_ID.'" />
			<RETURN>
				<INFO creator_info="true">
					<CREATIONDATE/>
					<TITLE/>
					<BODY/>
					<FILE />
					<TYPE />
				</INFO>
			</RETURN>
		</SEARCH>');

	$nql->addSupportTeam();
	$nql->addMonths();

	echo $nql->transform(dirname(__FILE__).'/List.xsl');
?>