<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/history/log.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<!-- VALUES/LABELS -->
	<xsl:template match="LOG" mode="field-value">
		<xsl:value-of select="INFO/VALUE"/>
	</xsl:template>
	
	<xsl:template match="LOG[INFO/FIELD/text() = /RESPONSE/RESULTS/FIELD[INFO/TYPE='list']/INFO/FIELDNAME]" mode="field-value">
		<xsl:variable name="field" select="/RESPONSE/RESULTS/FIELD[INFO/FIELDNAME=current()/INFO/FIELD]"/>
		<xsl:variable name="listname" select="$field/INFO/LISTNAME"/>
		<xsl:variable name="list" select="//LIST[@name=$listname]"/>
		<xsl:value-of select="$list/ITEM[@value=current()/INFO/VALUE]/@label"/>
	</xsl:template>
	
	<xsl:template match="LOG[INFO/FIELD/text() = /RESPONSE/RESULTS/FIELD[INFO/TYPE='systemList' and INFO/LISTNAME='Countries']/INFO/FIELDNAME]" mode="field-value">
		<xsl:value-of select="/RESPONSE/RESULTS/COUNTRY[@ID=current()/INFO/VALUE]/LABEL"/>
	</xsl:template>

	<xsl:template match="LOG[INFO/FIELD/text() = /RESPONSE/RESULTS/FIELD[INFO/TYPE='systemList' and INFO/LISTNAME='Languages']/INFO/FIELDNAME]" mode="field-value">
		<xsl:value-of select="/RESPONSE/RESULTS/LANGUAGE[@ID=current()/INFO/VALUE]/LABEL"/>
	</xsl:template>
	
	<xsl:template match="LANGUAGEID[text()!='shared']">
		<xsl:value-of select="/RESPONSE/RESULTS/LANGUAGE[@ID=current()/text()]/LABEL"/>
	</xsl:template>
	
	<!-- USER -->
	<xsl:template match="USER">
		<xsl:text>System</xsl:text>
	</xsl:template>
	<xsl:template match="USER[CONTACT]">
		<xsl:value-of select="CONTACT/INFO/FIRSTNAME"/>
        <xsl:text> </xsl:text>
        <xsl:value-of select="CONTACT/INFO/LASTNAME"/>
        <xsl:text> (</xsl:text>
		<xsl:value-of select="CONTACT/@ID" />
		<xsl:text>)</xsl:text>
	</xsl:template>
	
	<!-- INFO -->
	<xsl:template match="LOG[INFO/SERVICE = 'INFO']" mode="list"> 
		<xsl:variable name="itemID">
            <xsl:text>log-</xsl:text>
            <xsl:value-of select="position()"/>
        </xsl:variable>
		<div class="items open" id="{$itemID}">
            <div class="icon" style="display:none;">
                <a href="#" title="View complete modification" class="view">                                
                	<xsl:attribute name="onclick">
                        $('#<xsl:value-of select="$panelID"/>.panel').find('#<xsl:value-of select="$itemID"/>').toggleClass('open');
                	</xsl:attribute>
                </a>
            </div>
            <div class="label">
                <xsl:apply-templates select="INFO/DATE" mode="datetime"/>
                <xsl:text>> </xsl:text>
                <strong>
	                <xsl:value-of select="INFO/FIELD"/>
                </strong>
                <xsl:text>: </xsl:text>
                <em>
                    <xsl:apply-templates select="." mode="field-value"/>
                </em>
            </div>
            <div class="info">
				<xsl:apply-templates select="USER" />
            </div>
        </div>
	</xsl:template>
	
	<!-- DEPENDENCY -->
	<!--xsl:template match="LOG" mode="element-navitem-id">
	    <xsl:text>log-</xsl:text>
	    <xsl:value-of select="generate-id(.)"/>
	</xsl:template>
	
	<xsl:template match="LOG[INFO/SERVICE = 'DEPENDENCY']" mode="element-label">
		<xsl:apply-templates select="INFO/DATE" mode="datetime"/>
		<xsl:text>> </xsl:text>
		<strong>
			<xsl:value-of select="INFO/OPERATION"/>
			<xsl:text> </xsl:text>
			<xsl:value-of select="INFO/TYPE"/>
		</strong>
		<xsl:text> dependency</xsl:text>
		<em>
			<xsl:text> on </xsl:text>
			<strong>
				<xsl:value-of select="INFO/MODULE"/>
				<xsl:text> ID=</xsl:text>
				<xsl:value-of select="INFO/TARGETID"/>
			</strong>
		</em>
	</xsl:template>
	
	<xsl:template match="LOG[INFO/SERVICE = 'DEPENDENCY']" mode="element-script-detail">
		<xsl:value-of select="'../../system/tools/history/List'" />
	</xsl:template>
	
	<xsl:template match="LOG[INFO/SERVICE = 'DEPENDENCY']" mode="element-navitem-parms">
		<xsl:text>ID:</xsl:text>
		<xsl:value-of select="INFO/TARGETID"/>
		<xsl:text>,module:'</xsl:text>
		<xsl:value-of select="INFO/MODULE" />
		<xsl:text>'</xsl:text>
	</xsl:template>
	
	<xsl:template match="LOG" mode="element-icon">
		<a href="#" title="View complete modification" class="view">                         
			<xsl:attribute name="onclick">
				$(this).closest('items').toggleClass('open');
			</xsl:attribute>
		</a>
	</xsl:template>
	
	<xsl:template match="LOG" mode="element-info">
		<xsl:apply-templates select="USER" />
	</xsl:template>
	
	<xsl:template match="LOG[INFO/SERVICE = 'DEPENDENCY']" mode="list">		
		<xsl:call-template name="navigationitem">
			<xsl:with-param name="id">
                <xsl:apply-templates select="." mode="element-navitem-id"/>
            </xsl:with-param>
			<xsl:with-param name="title">
				<xsl:apply-templates select="." mode="element-label"/>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="." mode="element-script-detail"/>
			</xsl:with-param>
			<xsl:with-param name="params">
               <xsl:apply-templates select="." mode="element-navitem-parms"/>
            </xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon"/>
			</xsl:with-param>
			<xsl:with-param name="info">
				<xsl:apply-templates select="." mode="element-info"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template-->
	
	<xsl:template match="LOG[INFO/SERVICE = 'DEPENDENCY']" mode="list">		
		<xsl:variable name="itemID">
            <xsl:text>log-</xsl:text>
            <xsl:value-of select="position()"/>
        </xsl:variable>
		<div class="items open" id="{$itemID}">
            <div class="icon" style="display:none;">
                <a href="#" title="View complete modification" class="view">                                
                	<xsl:attribute name="onclick">
                        $('#<xsl:value-of select="$panelID"/>.panel').find('#<xsl:value-of select="$itemID"/>').toggleClass('open');
                	</xsl:attribute>
                </a>
            </div>
            <div class="label">
                <xsl:apply-templates select="INFO/DATE" mode="datetime"/>
                <xsl:text>> </xsl:text>
                <strong>
					<xsl:value-of select="INFO/OPERATION"/>
	                <xsl:text> </xsl:text>
	                <xsl:value-of select="INFO/TYPE"/>
                </strong>
                <xsl:text> dependency on </xsl:text>
                <em>
                	<xsl:text>element</xsl:text>
	                <!--xsl:value-of select="INFO/TARGETMODULE"/-->
					<strong>
						<xsl:text> ID=</xsl:text>
						<xsl:value-of select="INFO/TARGETID"/>
					</strong>
				</em>
            </div>
            <div class="info">
				<xsl:apply-templates select="USER" />
            </div>
        </div>
	</xsl:template>
	
	<!-- DESCRIPTION -->
	<xsl:template match="LOG[INFO/SERVICE = 'DESCRIPTION']" mode="list">
				<xsl:variable name="itemID">
            <xsl:text>log-</xsl:text>
            <xsl:value-of select="position()"/>
        </xsl:variable>
		<div class="items open" id="{$itemID}">
            <div class="icon" style="display:none;">
                <a href="#" title="View complete modification" class="view">                                
                	<xsl:attribute name="onclick">
                        $('#<xsl:value-of select="$panelID"/>.panel').find('#<xsl:value-of select="$itemID"/>').toggleClass('open');
                	</xsl:attribute>
                </a>
            </div>
            <div class="label">
                <xsl:apply-templates select="INFO/DATE" mode="datetime"/>
                <xsl:text>> </xsl:text>
                <strong>
                	<xsl:value-of select="INFO/FIELD"/>
                	<xsl:text> (</xsl:text>
					<xsl:apply-templates select="INFO/LANGUAGEID" />
                	<xsl:text>)</xsl:text>
                </strong>
                <xsl:text>: </xsl:text>
                <em>
					 <xsl:copy-of select="INFO/VALUE/node()" />
				</em>
            </div>
            <div class="info">
				<xsl:apply-templates select="USER" />
            </div>
        </div>
	</xsl:template>
	
	<!-- CATEGORY -->
	<xsl:template match="LOG[INFO/SERVICE = 'CATEGORY']" mode="list">
				<xsl:variable name="itemID">
            <xsl:text>log-</xsl:text>
            <xsl:value-of select="position()"/>
        </xsl:variable>
		<div class="items open" id="{$itemID}">
            <div class="icon" style="display:none;">
                <a href="#" title="View complete modification" class="view">                                
                	<xsl:attribute name="onclick">
                        $('#<xsl:value-of select="$panelID"/>.panel').find('#<xsl:value-of select="$itemID"/>').toggleClass('open');
                	</xsl:attribute>
                </a>
            </div>
            <div class="label">
                <xsl:apply-templates select="INFO/DATE" mode="datetime"/>
                <xsl:text>> </xsl:text>
                <strong>
					<xsl:value-of select="INFO/OPERATION"/>
                </strong>
                <xsl:text> category: </xsl:text>
                <em>
					<xsl:value-of select="/RESPONSE/RESULTS/CATEGORY[@ID=current()/INFO/CATEGORYID]/LABEL"/>
					<xsl:text> (ID=</xsl:text>
					<xsl:value-of select="INFO/CATEGORYID"/>
					<xsl:text>)</xsl:text>
				</em>
            </div>
            <div class="info">
				<xsl:apply-templates select="USER" />
            </div>
        </div>
	</xsl:template>
	
	<!-- COMMENT -->
	<xsl:template match="LOG[INFO/SERVICE = 'COMMENT']" mode="list">
		<xsl:if test="INFO/FIELD = 'Title'">
			<xsl:variable name="itemID">
	            <xsl:text>log-</xsl:text>
	            <xsl:value-of select="position()"/>
	        </xsl:variable>
			<xsl:variable name="commentID" select="INFO/COMMENTID"/>
			
			<div class="items open" id="{$itemID}">
	            <div class="icon" style="display:none;">
                <a href="#" title="View complete modification" class="view">                                
                	<xsl:attribute name="onclick">
                        $('#<xsl:value-of select="$panelID"/>.panel').find('#<xsl:value-of select="$itemID"/>').toggleClass('open');
                	</xsl:attribute>
                </a>
	            </div>
	            <div class="label">
	                <xsl:apply-templates select="INFO/DATE" mode="datetime"/>
	                <xsl:text>> </xsl:text>
	                <strong>
						<xsl:text>Comment</xsl:text>
	                </strong>
	                <xsl:text>: </xsl:text>
	                <em>
						<xsl:value-of select="INFO/VALUE"/>
						<xsl:text> (</xsl:text>
						<xsl:value-of select="$commentID"/>
						<xsl:text>)</xsl:text>
					</em>
	            </div>
	            <div class="info">
					<xsl:apply-templates select="USER" />
	            </div>
	        </div>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
