<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/panel/search.body.layout.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<xsl:import href="include.xsl"/>
   	
	<!--                		   -->
	<!-- SEARCH RESULTS BODY BLOCK -->
	<!--                		   -->
	
	<xsl:template name="block-search-results">
		<xsl:param name="list" select="/RESPONSE/RESULTS[@name='list']" />
		<xsl:param name="selectionList" select="/RESPONSE/RESULTS[@name='selections']" />
		<xsl:param name="actionsPanel" />
		
		<div class="hidden" id="search-nql-{$panelID}">
			<xsl:copy-of select="/RESPONSE/RESULTS[@name='search-nql']/*"/>
		</div>
		<script type="text/javascript">
			window.dirxml(document.getElementById('search-nql-<xsl:value-of select="$panelID" />').firstChild);
			/*$('#search-nql-<xsl:value-of select="$panelID" />').children().log();*/
		</script>
		
		<xsl:choose>
			<xsl:when test="count($list/*)&gt;0">
				<div class="block block-nav" id="options-navigation">
                	<xsl:call-template name="search-results-options">
                		<xsl:with-param name="actionsPanel" select="$actionsPanel" />
                	</xsl:call-template>
               	</div>
                   
				<xsl:call-template name="search-results-browser">
					<xsl:with-param name="list" select="$list"/>
				</xsl:call-template>                    

				<table class="search-results-table" id="datagrid" cellspacing="0">
					<thead>
						<xsl:apply-templates select="$list" mode="search-results-header"/>
					</thead>
					<tbody>
						<xsl:apply-templates select="$list/*" mode="search-results-body"/>
					</tbody>
					<xsl:apply-templates select="$selectionList/SELECTION" mode="search-results-selection"/>
				</table>

				<xsl:call-template name="search-results-browser">
					<xsl:with-param name="list" select="$list"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<div class="no-result">No hits found</div>
			</xsl:otherwise>
		</xsl:choose>	
	</xsl:template>
	
	<!-- options -->
	<xsl:template name="search-results-options">
		<xsl:param name="actionsPanel" />
		
        <xsl:call-template name="navigationitem">
            <xsl:with-param name="title">Display results configuration</xsl:with-param>
            <xsl:with-param name="panelURI">../../system/tools/filter/DisplayConfig</xsl:with-param>
            <xsl:with-param name="icon">
                <xsl:text>../system/images/icons/config-16.png</xsl:text>
            </xsl:with-param>
            <xsl:with-param name="params">
                <xsl:text>columns:'</xsl:text>
                <xsl:for-each select="$filter-display/RETURN//*[not(*)]">
                    <xsl:sort select="@order" order="ascending" data-type="number"/>
                    <xsl:choose>
                        <xsl:when test="ancestor::DEPENDENCY">
                            <!-- dependency modules fields -->
                            <xsl:text>DEPENDENCY[@type="</xsl:text>
                            <xsl:value-of select="ancestor::DEPENDENCY[1]/@type"/>
                            <xsl:text>"]/</xsl:text>
                        </xsl:when>
                        <xsl:when test="name(.)!='CATEGORIES'">
                            <!-- main module fields -->
                            <xsl:text>INFO/</xsl:text>
                        </xsl:when>
                    </xsl:choose>
                    <xsl:value-of select="name()"/>
                    <xsl:if test="position()!=last()"><xsl:text>,</xsl:text></xsl:if>
                </xsl:for-each>
                <xsl:text>',</xsl:text>
                <xsl:text>display:'</xsl:text>
                <xsl:value-of select="$filter-display/PAGINATE/@display"/>
                <xsl:text>',</xsl:text>
                <xsl:text>sort:'</xsl:text>
                <xsl:value-of select="$filter-display/SORT/@select"/>
                <xsl:text>',</xsl:text>
                <xsl:text>order:'</xsl:text>
                <xsl:value-of select="$filter-display/SORT/@order"/>
                <xsl:text>'</xsl:text>
                <xsl:text>,module:'</xsl:text><xsl:value-of select="$search-module-denom"/><xsl:text>'</xsl:text>
            </xsl:with-param>
        </xsl:call-template>
        <xsl:call-template name="navigationitem">
            <xsl:with-param name="title">Load a display configuration</xsl:with-param>
            <xsl:with-param name="panelURI">../../system/tools/filter/DisplayList</xsl:with-param>
            <xsl:with-param name="icon">
                <xsl:text>../system/images/icons/config.png</xsl:text>
            </xsl:with-param>
            <xsl:with-param name="params">
                <xsl:text>module:'</xsl:text><xsl:value-of select="$search-module-denom"/><xsl:text>'</xsl:text>
            </xsl:with-param>
        </xsl:call-template>
        <xsl:call-template name="nav-export-pdf">
            <xsl:with-param name="title">Generate a report with the results</xsl:with-param>
            <xsl:with-param name="module" select="$search-module-denom" />
        </xsl:call-template>
        <xsl:call-template name="nav-export-csv">
            <xsl:with-param name="title">Export the results</xsl:with-param>
            <xsl:with-param name="panelURI">../../system/tools/report/List</xsl:with-param>
            <xsl:with-param name="module" select="$search-module-denom" />
            <xsl:with-param name="moduleDesc" select="$search-module-desc" />
        </xsl:call-template>
        <xsl:call-template name="navigationitem">
            <xsl:with-param name="title">My reports</xsl:with-param>
            <xsl:with-param name="panelURI">../../system/tools/file/Folder</xsl:with-param>
            <xsl:with-param name="params">
                <xsl:text>path:'/contact/</xsl:text>
                <xsl:value-of select="$userID"/>
                <xsl:text>/reports/',parentPath:'/contact/</xsl:text>
                <xsl:value-of select="$userID"/>
                <xsl:text>/',name:'My reports',sort:'date'</xsl:text>
            </xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/libitems/folder.png</xsl:with-param>
            <xsl:with-param name="info"></xsl:with-param>
        </xsl:call-template>
        <xsl:if test="$actionsPanel">
	        <xsl:call-template name="navigationitem">
	            <xsl:with-param name="title">Actions on the results</xsl:with-param>
	            <xsl:with-param name="panelURI" select="$actionsPanel" />
	            <xsl:with-param name="icon">
	                <xsl:text>../system/images/icons/tool-16.png</xsl:text>
	            </xsl:with-param>
	        </xsl:call-template>
        </xsl:if>
        <xsl:call-template name="search-results-add-options" />
	</xsl:template>
	
    <!-- headers -->
    <xsl:template match="/RESPONSE/RESULTS[@name='list']" mode="search-results-header">
        <tr>
            <th class="checkboxcolumn">
                <input type="checkbox">
	                <!--xsl:if test="/RESPONSE/RESULTS[@name='selections']/SELECTION">
	                    <xsl:attribute name="checked">checked</xsl:attribute>
	                </xsl:if-->
                </input>
            </th>
            <xsl:for-each select="$filter-display/RETURN/INFO/* | $filter-display/RETURN/DEPENDENCIES/DEPENDENCY | $filter-display/RETURN/CATEGORIES">
                <xsl:sort select=".//@order" order="ascending" data-type="number"/>
                <xsl:apply-templates select="." mode="search-results-header"/>
            </xsl:for-each>
        </tr>
    </xsl:template>

    <!-- headers : main module fields -->
    <xsl:template match="INFO/*" mode="search-results-header">
        <th id="INFO/{name()}" class="listHeader" title="Sort on {name()}">
            <xsl:call-template name="get-module-field-name">
                <xsl:with-param name="moduleName" select="$search-module-denom"/>
                <xsl:with-param name="nodeName" select="name()"/>
            </xsl:call-template>
        </th>
    </xsl:template>

    <!-- headers : dependency module fields -->
    <xsl:template match="DEPENDENCY" mode="search-results-header">
        <!-- NB : no "listHeader" class to disable sort handlers -->
        <th id="DEPENDENCY[@type'{@type}']">
            <xsl:value-of select="$search-config/DEPENDENCIES/DEPENDENCY[TYPE=current()/@type]/MODULEDESC"/>
        </th>
    </xsl:template>
    
    <!-- headers : categories -->
    <xsl:template match="CATEGORIES" mode="search-results-header">
        <!-- NB : no "listHeader" class to disable sort handlers -->
        <th id="CATEGORIES">
        	<xsl:text>Categories</xsl:text>
        </th>
    </xsl:template>

	<!--  selections (hidden) -->
    <xsl:template match="SELECTION" mode="search-results-selection">
        <input type="hidden" name="selections[]" value="{@ID}"/>
    </xsl:template>

	<!-- browser -->
	<xsl:template name="search-results-browser">
		<xsl:param name="list"/>
		<xsl:param name="selectionList" select="/RESPONSE/RESULTS[@name='selections']" />
		<xsl:variable name="range" select="8"/>
		<xsl:variable name="delta" select="$range div 2"/>
		<xsl:variable name="hits" select="$list/@hits"/>
		<xsl:variable name="page" select="$list/@page"/>
		<xsl:variable name="pages" select="$list/@pages"/>

		<div class="list-browser">
			<div class="pager">
				<xsl:call-template name="pager-button">
					<xsl:with-param name="id" select="'1'"/>
					<xsl:with-param name="page" select="$page"/>
                    <xsl:with-param name="event" select="'search-loadpage'"/>
				</xsl:call-template>
				<xsl:if test="$pages &gt; 2">
					<xsl:text>&#160;-&#160;</xsl:text>
					<xsl:choose>
						<xsl:when test="$page &lt; $delta">
							<xsl:for-each select="//E[text() + 1 &lt; $range + 1]">
								<xsl:if test="text() + 1 &lt; $pages">
									<xsl:variable name="pageid" select="text() + 1"/>
									<xsl:call-template name="pager-button">
										<xsl:with-param name="id" select="$pageid"/>
										<xsl:with-param name="page" select="$page"/>
                                        <xsl:with-param name="event" select="'search-loadpage'"/>
									</xsl:call-template>
								</xsl:if>
							</xsl:for-each>
						</xsl:when>
						<xsl:when test="$page &gt; $pages - $delta">
							<xsl:for-each select="//E[text() &lt; $range]">
								<xsl:if test="text() - 1 &gt; $range - $pages">
									<xsl:variable name="pageid" select="$pages - ($range - text())"/>
									<xsl:call-template name="pager-button">
										<xsl:with-param name="id" select="$pageid"/>
										<xsl:with-param name="page" select="$page"/>
                                        <xsl:with-param name="event" select="'search-loadpage'"/>
									</xsl:call-template>
								</xsl:if>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<xsl:for-each select="//E[text() - 1 &lt; ($range - 1)]">
								<xsl:variable name="pageid" select="$page - $delta + text()"/>
								<xsl:call-template name="pager-button">
									<xsl:with-param name="id" select="$pageid"/>
									<xsl:with-param name="page" select="$page"/>
                                    <xsl:with-param name="event" select="'search-loadpage'"/>
								</xsl:call-template>
							</xsl:for-each>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				<xsl:if test="$pages != 1">
					<xsl:text>&#160;-&#160;</xsl:text>
					<xsl:call-template name="pager-button">
						<xsl:with-param name="id" select="$pages"/>
						<xsl:with-param name="page" select="$page"/>
						<xsl:with-param name="pages" select="$pages"/>
                        <xsl:with-param name="event" select="'search-loadpage'"/>
					</xsl:call-template>
				</xsl:if>
			</div>
			<div class="hits">
                <xsl:choose>
                    <xsl:when test="$selectionList/@display = 'no' or not($selectionList/@display)">
                        <strong class="lasthits-count">
                            <xsl:value-of select="$hits"/>
                        </strong>
                        <xsl:text> hit(s)</xsl:text>
                        <xsl:text> | </xsl:text>
                        <xsl:choose>
                            <xsl:when test="$selectionList/@count > 0">
                                <a href="#" class="selection-link" onclick="$('#{$panelID}.panel').trigger('search-displayselections', [1,true]); return false;" title="Browse selection">
                                    <span class="selection-text">
                                        <strong class="selected-count">
                                            <xsl:value-of select="$selectionList/@count"/>
                                        </strong>
                                        <xsl:text> sel.</xsl:text>
                                    </span>
                                </a>
                            </xsl:when>
                            <xsl:otherwise>
                                <span class="selection-text">
                                    <strong class="selected-count">
                                        <xsl:text>0</xsl:text>
                                    </strong>
                                    <xsl:text> sel.</xsl:text>
                                </span>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <a href="#" onclick="$('#{$panelID}.panel').trigger('search-displayselections', [1,false]); return false;">
                            <strong class="lasthits-count">
                            	<xsl:value-of select="$selectionList/@lasthits"/>
                           	</strong>
                            <xsl:text> hit(s)</xsl:text>
                        </a>
                        <xsl:text> | </xsl:text>
                        <span class="selection-text">
                            <strong class="selected-count">
                            	<xsl:value-of select="$selectionList/@count"/>
                           	</strong>
                           	<xsl:text> sel.</xsl:text>
                        </span>
                    </xsl:otherwise>
                </xsl:choose>
			</div>
			<div class="options" id="open-options">
                <a href="#" title="Show options">
                    <xsl:text>Show options</xsl:text>
                </a>
			</div>
			<div class="options optionsOpened" id="close-options">
                <a href="#" title="Hide">
                    <xsl:text>Hide options</xsl:text>
                </a>
			</div>
		</div>
	</xsl:template>
	
	<!-- results list -->
	<xsl:template match="*" mode="search-results-body">
		<xsl:variable name="currentData" select="."/>
	
        <tr class="items odd">
            <xsl:attribute name="onclick">
                <xsl:call-template name="navactionhandler">
					<xsl:with-param name="editor">
						<xsl:apply-templates select="." mode="element-application-editor"/>
					</xsl:with-param>
					<xsl:with-param name="app">
						<xsl:apply-templates select="." mode="element-application"/>
					</xsl:with-param>
                    <xsl:with-param name="title">
                        <xsl:apply-templates select="." mode="element-label"/>
                    </xsl:with-param>
                    <xsl:with-param name="panelURI">
                        <xsl:apply-templates select="." mode="element-script-detail"/>
                    </xsl:with-param>
                    <xsl:with-param name="icon">
                    	<xsl:apply-templates select="." mode="element-icon"/>
                    </xsl:with-param>
					<xsl:with-param name="params">
		               <xsl:apply-templates select="." mode="element-navitem-parms"/>
		            </xsl:with-param>
                </xsl:call-template>
            </xsl:attribute>
			<xsl:if test="position() mod 2 = 0">
				<xsl:attribute name="class">items even</xsl:attribute>		
			</xsl:if>
            <td class="checkboxcolumn">
                <input type="checkbox" value="{@ID}" name="results[]">
                    <xsl:if test="/RESPONSE/RESULTS[@name='selections']/SELECTION/@ID = @ID">
                        <xsl:attribute name="checked">checked</xsl:attribute>
                    </xsl:if>
                </input>
            </td>

            <xsl:for-each select="$filter-display/RETURN/INFO/* | $filter-display/RETURN/DEPENDENCIES/DEPENDENCY | $filter-display/RETURN/CATEGORIES">
                <xsl:sort select=".//@order" order="ascending" data-type="number"/>
                <td>
                    <xsl:choose>
                        <!-- main module fields -->
                        <xsl:when test="parent::INFO">
                        	<xsl:choose>
		                        <xsl:when test="name(.)='OWNERS' or name(.)='GROUPS'">
		                        	<xsl:for-each select="$currentData/INFO/*[name()=name(current())]/*">
		                        		<xsl:apply-templates select="." mode="element-label" />
		                        		<xsl:if test="position()!=last()">
		                        			<xsl:text>, </xsl:text>
		                        		</xsl:if>
		                        	</xsl:for-each>
		                        </xsl:when>
                        		<xsl:when test="name()='CREATORID'">
                        			<xsl:apply-templates select="$currentData/INFO/CREATOR/CONTACT" mode="element-label"/>
                        			<xsl:text> (</xsl:text>
                        			<xsl:value-of select="$currentData/INFO/CREATORID" />
                        			<xsl:text>)</xsl:text>
                        		</xsl:when>
                        		<xsl:when test="name()='MODIFIERID'">
                        			<xsl:apply-templates select="$currentData/INFO/MODIFIER/CONTACT" mode="element-label"/>
                        			<xsl:text> (</xsl:text>
                        			<xsl:value-of select="$currentData/INFO/MODIFIERID" />
                        			<xsl:text>)</xsl:text>
                        		</xsl:when>
                        		<xsl:when test="name()='OWNERID'">
                        			<xsl:apply-templates select="$currentData/INFO/OWNER/CONTACT" mode="element-label"/>
                        			<xsl:text> (</xsl:text>
                        			<xsl:value-of select="$currentData/INFO/OWNERID" />
                        			<xsl:text>)</xsl:text>
                        		</xsl:when>
                        		<xsl:otherwise>
		                            <xsl:call-template name="get-module-field-value">
		                                <xsl:with-param name="moduleName" select="$search-module-denom"/>
		                                <xsl:with-param name="node" select="$currentData/INFO/*[name()=name(current())]"/>
		                            </xsl:call-template>
	                            </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
	                    <xsl:when test="name(.)='CATEGORIES'">
                        	<xsl:for-each select="$currentData/CATEGORIES/CATEGORY">
                        		<xsl:apply-templates select="." mode="element-label" />
                        		<!--xsl:text> (</xsl:text>
                        		<xsl:value-of select="@path" />
                        		<xsl:text>)</xsl:text-->
                        		<xsl:if test="position()!=last()">
                        			<xsl:text>, </xsl:text>
                        		</xsl:if>
                        	</xsl:for-each>
	                    </xsl:when>
                        <xsl:otherwise>
                            <!-- dependency module fields -->
                            <xsl:variable name="currentFilterDep" select="."/>
                            <xsl:variable name="targetModuleDenom" select="$search-config/DEPENDENCIES/DEPENDENCY[TYPE=current()/@type]/MODULE"/>
                            
                            <xsl:for-each select="$currentData/DEPENDENCIES/DEPENDENCY[@type=current()/@type]/*">
                                <xsl:variable name="currentElemTarget" select="."/>
                                <xsl:for-each select="$currentFilterDep/INFO/*">
                                    <xsl:sort select="@order" order="ascending" data-type="number"/>
                                    
                                    <xsl:choose>
				                        <xsl:when test="name()='OWNERS' or name()='GROUPS'">
				                        	<xsl:for-each select="$currentElemTarget/INFO/*[name()=name(current())]/*">
				                        		<xsl:apply-templates select="." mode="element-label" />
			                        			<xsl:text> (</xsl:text>
			                        			<xsl:value-of select="@ID" />
			                        			<xsl:text>)</xsl:text>
				                        		<xsl:if test="position()!=last()">
				                        			<xsl:text>, </xsl:text>
				                        		</xsl:if>
				                        	</xsl:for-each>
				                        </xsl:when>
		                        		<xsl:when test="name()='CREATORID'">
		                        			<xsl:apply-templates select="$currentElemTarget/INFO/CREATOR/CONTACT" mode="element-label"/>
		                        			<xsl:text> (</xsl:text>
		                        			<xsl:value-of select="$currentElemTarget/INFO/CREATORID" />
		                        			<xsl:text>)</xsl:text>
		                        		</xsl:when>
		                        		<xsl:when test="name()='MODIFIERID'">
		                        			<xsl:apply-templates select="$currentElemTarget/INFO/MODIFIER/CONTACT" mode="element-label"/>
		                        			<xsl:text> (</xsl:text>
		                        			<xsl:value-of select="$currentElemTarget/INFO/MODIFIERID" />
		                        			<xsl:text>)</xsl:text>
		                        		</xsl:when>
		                        		<xsl:when test="name()='OWNERID'">
		                        			<xsl:apply-templates select="$currentElemTarget/INFO/OWNER/CONTACT" mode="element-label"/>
		                        			<xsl:text> (</xsl:text>
		                        			<xsl:value-of select="$currentElemTarget/INFO/OWNERID" />
		                        			<xsl:text>)</xsl:text>
		                        		</xsl:when>
		                        		<xsl:otherwise>
		                                    <xsl:call-template name="get-module-field-value">
		                                        <xsl:with-param name="moduleName" select="$targetModuleDenom"/>
		                                        <xsl:with-param name="node" select="$currentElemTarget/INFO/*[name()=name(current())]"/>
		                                    </xsl:call-template>
		                                </xsl:otherwise>
                                	</xsl:choose>
                                    <xsl:if test="position()!=last()">,&#160;</xsl:if>
                                </xsl:for-each>
                                <xsl:if test="position()!=last()"><br/></xsl:if>
                            </xsl:for-each>
                        </xsl:otherwise>
                    </xsl:choose>
                </td>
            </xsl:for-each>
        </tr>
	</xsl:template>
	
	<!--                		   				-->
	<!-- SEARCH RESULTS BODY BLOCK (EDITABLE)	-->
	<!--                		   				-->
	
	<xsl:template name="block-search-results-editable">
		<xsl:param name="list" select="/RESPONSE/RESULTS[@name='list']" />
		<xsl:param name="selectionList" select="/RESPONSE/RESULTS[@name='selections']" />
		<xsl:param name="actionsPanel" />
		<xsl:variable name="formID">
			<xsl:text>form-search-edit-</xsl:text>
			<xsl:value-of select="$panelID" />			
		</xsl:variable>
		
		<xsl:choose>
			<xsl:when test="count($list/*)&gt;0">
				<div class="block block-nav" id="options-navigation">	
                	<xsl:call-template name="search-results-options">
                		<xsl:with-param name="actionsPanel" select="$actionsPanel" />
                	</xsl:call-template>
               	</div>

   				<xsl:call-template name="search-results-body-editable-actions">
   					<xsl:with-param name="list" select="$list"/>
   				</xsl:call-template>
		
				<form name="{$formID}" id="{$formID}" class="search-results-edit-form">
					<table class="search-results-table" id="datagrid" cellspacing="0">
						<thead>
							<xsl:apply-templates select="$list" mode="search-results-header-editable"/>
						</thead>
						<tbody>
							<xsl:apply-templates select="$list/*" mode="search-results-body-editable"/>
						</tbody>
						<xsl:apply-templates select="$selectionList/SELECTION" mode="search-results-selection"/>
					</table>
				</form>
				
   				<xsl:call-template name="search-results-body-editable-actions">
   					<xsl:with-param name="list" select="$list"/>
   				</xsl:call-template>
				
				<script type="text/javascript">
					<xsl:call-template name="block-search-results-editable-js">
						<xsl:with-param name="formID" select="$formID"/>
					</xsl:call-template>
				</script>
			</xsl:when>
			<xsl:otherwise>
				<div class="no-result">No hits found</div>
			</xsl:otherwise>
		</xsl:choose>	
	</xsl:template>
	
    <xsl:template match="/RESPONSE/RESULTS[@name='list']" mode="search-results-header-editable">
        <tr>
            <th class="checkboxcolumn">
                <input type="checkbox" />
            </th>
            <xsl:for-each select="$filter-display/RETURN/INFO/* | $filter-display/RETURN/DEPENDENCIES/DEPENDENCY">
                <xsl:sort select=".//@order" order="ascending" data-type="number"/>
                <xsl:apply-templates select="." mode="search-results-header"/>
            </xsl:for-each>
        </tr>
    </xsl:template>
	
	<xsl:template name="search-results-body-editable-actions">
		<xsl:param name="list" />
		<xsl:param name="selectionList" select="/RESPONSE/RESULTS[@name='selections']" />
		<xsl:variable name="hits" select="$list/@hits"/>
		
		<div class="list-browser">
			<div class="pager">
				<input type="button" value="Update selected results set" class="update-results-button" />
			</div>
			<div class="hits">
                <xsl:choose>
                    <xsl:when test="$selectionList/@display = 'no' or not($selectionList/@display)">
                        <strong class="lasthits-count">
                            <xsl:value-of select="$hits"/>
                        </strong>
                        <xsl:text> hit(s)</xsl:text>
                        <xsl:text> | </xsl:text>
                        <xsl:choose>
                            <xsl:when test="$selectionList/@count > 0">
                                <a href="#" class="selection-link" onclick="$('#{$panelID}.panel').trigger('search-displayselections', [1,true]); return false;" title="Browse selection">
                                    <span class="selection-text">
                                        <strong class="selected-count">
                                            <xsl:value-of select="$selectionList/@count"/>
                                        </strong>
                                        <xsl:text> sel.</xsl:text>
                                    </span>
                                </a>
                            </xsl:when>
                            <xsl:otherwise>
                                <span class="selection-text">
                                    <strong class="selected-count">
                                        <xsl:text>0</xsl:text>
                                    </strong>
                                    <xsl:text> sel.</xsl:text>
                                </span>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <a href="#" onclick="$('#{$panelID}.panel').trigger('search-displayselections', [1,false]); return false;">
                            <strong class="lasthits-count">
                            	<xsl:value-of select="$selectionList/@lasthits"/>
                           	</strong>
                            <xsl:text> hit(s)</xsl:text>
                        </a>
                        <xsl:text> | </xsl:text>
                        <span class="selection-text">
                            <strong class="selected-count">
                            	<xsl:value-of select="$selectionList/@count"/>
                           	</strong>
                           	<xsl:text> sel.</xsl:text>
                        </span>
                    </xsl:otherwise>
                </xsl:choose>
			</div>
			<div class="options" id="open-options">
                <a href="#" title="Show options">
                    <xsl:text>Show options</xsl:text>
                </a>
			</div>
			<div class="options optionsOpened" id="close-options">
                <a href="#" title="Hide">
                    <xsl:text>Hide options</xsl:text>
                </a>
			</div>
		</div>
	</xsl:template>
	
	<!-- editable results list -->
	<xsl:template match="*" mode="search-results-body-editable">
		<xsl:variable name="currentData" select="."/>
	
        <tr class="items odd">
			<xsl:if test="position() mod 2 = 0">
				<xsl:attribute name="class">items even</xsl:attribute>		
			</xsl:if>
            <td class="checkboxcolumn">
                <input type="checkbox" value="{@ID}" name="results[]" />
            </td>

            <xsl:for-each select="$filter-display/RETURN/INFO/* | $filter-display/RETURN/DEPENDENCIES/DEPENDENCY">
                <xsl:sort select=".//@order" order="ascending" data-type="number"/>
                <td>
                    <xsl:choose>
                        <!-- main module fields -->
                        <xsl:when test="parent::INFO and (name()!='ID')">
                        	<xsl:variable name="field" select="/RESPONSE/RESULTS/FIELD[INFO/MODULE=$search-module-denom and INFO/DENOMINATION=name(current())]" />
				           <xsl:call-template name="field-input">
					           	<xsl:with-param name ="field" select="$field"/>
					           	<xsl:with-param name ="node" select="$currentData/INFO/*[name()=name(current())]"/>
					           	<xsl:with-param name="inputName">
							      	<xsl:call-template name="gen-info-input-name">
										<xsl:with-param name="moduleName" select="$search-module-denom" />
										<xsl:with-param name="fieldName" select="$field/INFO/DENOMINATION"/>
										<xsl:with-param name="type">
											<xsl:value-of select="$field/INFO/TYPE" />
											<xsl:text>-</xsl:text>
											<xsl:value-of select="$currentData/@ID" />
										</xsl:with-param>
							      	</xsl:call-template>
					           	</xsl:with-param>
				          	</xsl:call-template>
                        </xsl:when>
                        <xsl:when test="parent::INFO and (name()='ID')">
                            <xsl:call-template name="get-module-field-value">
                                <xsl:with-param name="moduleName" select="$search-module-denom"/>
                                <xsl:with-param name="node" select="$currentData/INFO/*[name()=name(current())]"/>
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:otherwise>
                            <!-- dependency module fields -->
                            <xsl:variable name="currentFilterDep" select="."/>
                            <xsl:variable name="targetModuleDenom" select="$search-config/DEPENDENCIES/DEPENDENCY[TYPE=current()/@type]/MODULE"/>
                            
                            <xsl:for-each select="$currentData/DEPENDENCIES/DEPENDENCY[@type=current()/@type]/*">
                                <xsl:variable name="currentElemTarget" select="."/>
                                <xsl:for-each select="$currentFilterDep/INFO/*">
                                    <xsl:sort select="@order" order="ascending" data-type="number"/>
                                    <xsl:call-template name="get-module-field-value">
                                        <xsl:with-param name="moduleName" select="$targetModuleDenom"/>
                                        <xsl:with-param name="node" select="$currentElemTarget/INFO/*[name()=name(current())]"/>
                                    </xsl:call-template>
                                    <xsl:if test="position()!=last()">,&#160;</xsl:if>
                                </xsl:for-each>
                                <xsl:if test="position()!=last()"><br/></xsl:if>
                            </xsl:for-each>
                        </xsl:otherwise>
                    </xsl:choose>
                </td>
            </xsl:for-each>
        </tr>
	</xsl:template>
	
	<xsl:template name="block-search-results-editable-js">
		<xsl:param name="formID" />
		$('#<xsl:value-of select="$panelID" />.panel').find('.search-results-table .input-date').datepicker({
			dateFormat: 'dd/mm/yy',
			buttonImage: 'http://www.officity.com/apps/system/images/icons/calendar.png',
			buttonImageOnly: true,
			buttonText: 'Choose date',
			showOn: 'button',
			firstDay: 1,
			showOtherMonths: true,
			isRTL: false,
            changeYear: true,
            yearRange: '1900:2100',
            showAnim: 'fadeIn',
			onSelect : function(dateText, inst)
			{
				$(this).closest('.items').find(':checkbox[name=results[]]').attr('checked', 'checked');
			}
		});
			
		var inputs = $('#<xsl:value-of select="$panelID" />.panel').find('#datagrid').find('.items').find(':input[name!=results[]]');
		
		inputs.filter('select,:checkbox').change(function(){
			$(this).closest('.items').find(':checkbox[name=results[]]').attr('checked', 'checked');
		});
		
		inputs.filter('input').keydown(function(){
			$(this).closest('.items').find(':checkbox[name=results[]]').attr('checked', 'checked');
		});
	</xsl:template>
</xsl:stylesheet>