<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/report/csv/generic-csv-export-max-deps.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output encoding="UTF-8" method="xml" indent="no" omit-xml-declaration="yes"/>
	<xsl:strip-space elements="*"/>

    <xsl:param name="items" select="/RESPONSE/RESULTS[@name='data']/*"/>

	<xsl:template match="/RESPONSE">
        <RESULTS static="true" name="data">
            <xsl:copy-of select="RESULTS[@name='data']/*"/>
        </RESULTS>
        <RESULTS static="true" name="search-filter">
            <INFO>
                <xsl:apply-templates select="RESULTS[@name='search-filter']/INFO/*" mode="filter"/>
            </INFO>
        </RESULTS>
    </xsl:template>

    <xsl:template match="*" mode="filter">
        <xsl:copy-of select="."/>
    </xsl:template>

    <xsl:template match="DISPLAYXML" mode="filter">
        <DISPLAYXML>
            <RETURN>
                <xsl:copy-of select="RETURN/INFO"/>
                <DEPENDENCIES>
                    <xsl:apply-templates select="RETURN/DEPENDENCIES/DEPENDENCY" mode="max-dep-items"/>
                </DEPENDENCIES>
            </RETURN>
            <xsl:copy-of select="SORT"/>
            <xsl:copy-of select="PAGINATE"/>
        </DISPLAYXML>
    </xsl:template>

    <xsl:template match="DEPENDENCY" mode="max-dep-items">
        <xsl:variable name="dep-type" select="./@type"/>
        <xsl:variable name="all-items-deps" select="$items//DEPENDENCY[@type=$dep-type]"/>
        <xsl:variable name="max-count" select="$all-items-deps[not(@hits&lt;(preceding::DEPENDENCY[@type=$dep-type]/@hits | following::DEPENDENCY[@type=$dep-type]/@hits))][1]/@hits" />
        <xsl:copy select=".">
            <xsl:copy-of select="@*"/>
            <xsl:attribute name="max">
                <xsl:value-of select="$max-count"/>
            </xsl:attribute>
            <xsl:copy-of select="./*"/>
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>
