<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/security/SecurityActions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:OFFICITY="http://officity.com" version="1.0">
	<xsl:import href="include.xsl"/>
	<xsl:output encoding="UTF-8" method="xml" indent="no"/>
	<xsl:strip-space elements="*"/>

	<xsl:template match="/RESPONSE">
		<xsl:call-template name="panel-navigation"/>
	</xsl:template>

	<xsl:template name="panel-body-navigation">
		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Users'"/>
			<xsl:with-param name="panelURI" select="'../../system/tools/security/OwnersPermissions'"/>
			<xsl:with-param name="params">
				<xsl:text>elementID:</xsl:text><xsl:value-of select="/RESPONSE/URL/elementID"/>
				<xsl:text>,module:'</xsl:text><xsl:value-of select="/RESPONSE/URL/module"/><xsl:text>'</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:text>../system/images/icons/contacts/contacts-18.png</xsl:text>
			</xsl:with-param> 
		</xsl:call-template>

		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Groups'"/>
			<xsl:with-param name="panelURI" select="'../../system/tools/security/GroupsPermissions'"/>
			<xsl:with-param name="params">
				<xsl:text>elementID:</xsl:text><xsl:value-of select="/RESPONSE/URL/elementID"/>
				<xsl:text>,module:'</xsl:text><xsl:value-of select="/RESPONSE/URL/module"/><xsl:text>'</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:text>../system/images/icons/contacts/group-16.png</xsl:text>
			</xsl:with-param> 
		</xsl:call-template>
	
		<xsl:if test="/RESPONSE/URL/tree != 'false'">
			<xsl:call-template name="navigationdetailsitem">
				<xsl:with-param name="title" select="'Apply Permissions'"/>
				<xsl:with-param name="panelURI" select="'../../system/tools/security/ApplyPermissions'"/>
				<xsl:with-param name="params">
					<xsl:text>elementID:</xsl:text><xsl:value-of select="/RESPONSE/URL/elementID"/>
					<xsl:text>,module:'</xsl:text><xsl:value-of select="/RESPONSE/URL/module"/><xsl:text>'</xsl:text>
				</xsl:with-param>
				<xsl:with-param name="icon">
					<xsl:text>../system/images/icons/config.png</xsl:text>
				</xsl:with-param> 
			</xsl:call-template>
		</xsl:if>

	</xsl:template>

</xsl:stylesheet>
